/* 
SIMPLE.C -- not so simple, really

Microsoft C, Windows SDK:
cl -c -AS -Gsw -Oais -Zpe simple.c
link /align:16 simple,simple,nul,/nod slibcew libw,simple.def
rc simple.exe

; SIMPLE.DEF
NAME        SIMPLE
EXETYPE     WINDOWS
CODE        PRELOAD MOVEABLE DISCARDABLE
DATA        PRELOAD MOVEABLE MULTIPLE
HEAPSIZE    4096
STACKSIZE   8192
EXPORTS     WndProc

Borland C++ (no .DEF file required):
bcc -WS -G -O -Z -w-par -Hu simple.c
rc simple.exe
*/

#include <stdarg.h>
#include "windows.h"

static unsigned height;

int hprintf(HDC hdc, int linenum, const char *fmt, ...)
{
    static char s[256];
    int len;
    va_list marker;
    va_start(marker, fmt);
    TextOut(hdc, 0, linenum * height, s,
        len = wvsprintf(s, fmt, marker));
    va_end(marker);
    return len;
}

long FAR PASCAL _export WndProc(HWND hwnd, WORD message, 
    WORD wParam, LONG lParam)
{
    HDC hdc;
    PAINTSTRUCT ps;
    TEXTMETRIC tm;
    unsigned vers, flags;
    int i;
    
    switch (message)
    {
        case WM_CREATE:
            hdc = GetDC(hwnd);
            GetTextMetrics(hdc, &tm);
            height = tm.tmHeight + tm.tmExternalLeading;
            ReleaseDC(hwnd, hdc);
            return 0;
            
        case WM_PAINT:
            vers = GetVersion();
            flags = GetWinFlags();
            hdc = BeginPaint(hwnd, &ps);
            i = 0;
            hprintf(hdc, i++, "Windows v. %d.%d", 
                LOBYTE(vers), HIBYTE(vers));
            hprintf(hdc, i++, "%s mode", (char far *)
                ((flags & WF_ENHANCED) ? "Enhanced" :
                (flags & WF_STANDARD)  ? "Standard" :
                /* default */            "Real"));
            hprintf(hdc, i++, "%d tasks running", 
                GetNumTasks());
            EndPaint(hwnd, &ps);
            return 0;
            
        case WM_DESTROY:
            PostQuitMessage(0);
            return 0;
            
        default:
            return DefWindowProc(hwnd, message, wParam, lParam);
    }
}

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
    LPSTR lpszCmdParam, int nCmdShow)
{
    HWND hwnd;
    MSG msg;
    WNDCLASS wndclass;
    
    if (! hPrevInstance)
    {
        wndclass.style = CS_HREDRAW | CS_VREDRAW | CS_BYTEALIGNCLIENT;
        wndclass.lpfnWndProc = WndProc;
        wndclass.cbClsExtra = 0;
        wndclass.cbWndExtra = 0;
        wndclass.hInstance = hInstance;
        wndclass.hIcon = LoadIcon(NULL, IDI_APPLICATION);
        wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
        wndclass.hbrBackground = GetStockObject(WHITE_BRUSH);
        wndclass.lpszMenuName = NULL;
        wndclass.lpszClassName = "test";
        RegisterClass(&wndclass);
    }
    
    hwnd = CreateWindow("test", "TEST", WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
        NULL, NULL, hInstance, NULL);
    
    ShowWindow(hwnd, nCmdShow);
    UpdateWindow(hwnd);
    
    while (GetMessage(&msg, NULL, 0, 0))
    {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }
    
    return msg.wParam;
}

