/*-------------------------------------------------------------*\
 |   SYSSEG.C  -- Creates two iconized windows to monitor     |
 |                 the available heap space for USER and GDI.  |
\*-------------------------------------------------------------*/
#include <Windows.H>

#define MAXDOSERROR 32

/*-------------------------------------------------------------*\
 |                    Function Prototypes.                     |
\*-------------------------------------------------------------*/
long FAR  PASCAL SysSegWndProc (HWND, WORD, WORD, LONG);


/*-------------------------------------------------------------*\
 |                    Global Variables.                        |
\*-------------------------------------------------------------*/
HWND hwnd1;
HWND hwnd2;

/*-------------------------------------------------------------*\
 |                  Main Function:  WinMain.                   |
\*-------------------------------------------------------------*/
int PASCAL WinMain (HANDLE hInstance,   HANDLE hPrevInstance,
                    LPSTR  lpszCmdLine, int    cmdShow)
    {
    MSG      msg;
    WNDCLASS wndclass;

    if (!hPrevInstance)
        {
        wndclass.lpszClassName = "SysSeg:MAIN";
        wndclass.hInstance     = hInstance;
        wndclass.lpfnWndProc   = SysSegWndProc;
        wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW);
        wndclass.hIcon         = 0;
        wndclass.lpszMenuName  = NULL;
        wndclass.hbrBackground = COLOR_WINDOW+1;
        wndclass.style         = NULL;
        wndclass.cbClsExtra    = 0;
        wndclass.cbWndExtra    = 2;

        RegisterClass( &wndclass);
        }

    hwnd1= CreateWindow("SysSeg:MAIN",       /* Class name.   */
                        "GDI",                /* Title.        */
                        WS_OVERLAPPEDWINDOW,  /* Style bits.   */
                        0,                    /* x - default.  */
                        0,                    /* y - default.  */
                        0,                    /* cx - default. */
                        0,                    /* cy - default. */
                        NULL,                 /* No parent.    */
                        NULL,                 /* Class menu.   */
                        hInstance,            /* Creator.      */
                        NULL);                /* Params.       */

    // Set timer to check every second.
    SetTimer (hwnd1, 1, 1000, 0L);

    hwnd2= CreateWindow("SysSeg:MAIN",       /* Class name.   */
                        "USER",               /* Title.        */
                        WS_OVERLAPPEDWINDOW,  /* Style bits.   */
                        0,                    /* x - default.  */
                        0,                    /* y - default.  */
                        0,                    /* cx - default. */
                        0,                    /* cy - default. */
                        NULL,                 /* No parent.    */
                        NULL,                 /* Class menu.   */
                        hInstance,            /* Creator.      */
                        NULL);                /* Params.       */

    ShowWindow (hwnd1, SW_SHOWMINIMIZED);
    ShowWindow (hwnd2, SW_SHOWMINIMIZED);

    while (GetMessage(&msg, 0, 0, 0))
        {
        TranslateMessage(&msg);       /*  Keyboard input.      */
        DispatchMessage(&msg);
        }
    return 0;
    }


/*-------------------------------------------------------------*\
 |            Window Procedure:  SysSegWndProc.               |
\*-------------------------------------------------------------*/
long FAR PASCAL SysSegWndProc (HWND hwnd,   WORD wMsg,
                                WORD wParam, LONG lParam)
    {
    static HANDLE hbrNull;

    switch (wMsg)
        {
        case WM_CREATE:
            {
            char           achLibName[50];
            char           achTitle[50];
            HANDLE         hLib;
            LPCREATESTRUCT lpcreate;

            // Create library names USER.EXE and GDI.EXE
            lpcreate = (LPCREATESTRUCT)lParam;
            lstrcpy (achLibName, lpcreate->lpszName);
            lstrcat (achLibName, ".EXE");

            // Try getting handle to library.
            hLib = LoadLibrary (achLibName);
            FreeLibrary (hLib);

            // Did we fail?
            if (hLib < MAXDOSERROR)
                {
                MessageBox (hwnd, "Cannot load library",
                            "SysSeg", 0);
                return -1L;
                }

            /*
             *  Create a nicer window title.
             */
            lstrcpy (achTitle, lpcreate->lpszName);
            lstrcat (achTitle, " Data Seg");
            SendMessage (hwnd, WM_SETTEXT, 0, (LONG)(LPSTR)achTitle);

            // Place segment handle in window extra bytes.
            SetWindowWord (hwnd, 0, hLib);

            hbrNull = GetStockObject (NULL_BRUSH);
            }
            break;

        case WM_DESTROY:
            PostQuitMessage(0);
            break;

        case WM_ERASEBKGND:
            return 1L;
            break;

        case WM_QUERYOPEN:
            /*
             *  If someone knocks, ignore them.  Don't open
             *  the iconized window.
             */
            return 0L;
            break;

        case WM_PAINT:
            {
            char        ach[50];
            DWORD       dwSize;
            DWORD       dwSegment;
            HANDLE      hLib;
            int         cb;
            int         iPercent;
            int         xWidth, yHeight;
            int         X, Y;
            PAINTSTRUCT ps;
            RECT        rClient;
            RECT        rOpaque;
            RECT        rPlain;

            BeginPaint (hwnd, &ps);

            // Get size of segment.
            hLib = GetWindowWord (hwnd, 0);
            dwSegment = GlobalSize (hLib);

            // Calculate percent
            iPercent = (int)(dwSegment/655);
            cb = wsprintf (ach, "%d%%", iPercent);

            // Get dimensions of text.
            dwSize  = GetTextExtent (ps.hdc, ach, cb);
            xWidth  = LOWORD (dwSize);
            yHeight = HIWORD (dwSize);

            // Position text in center of icon.
            GetClientRect (hwnd, &rClient);
            X = (rClient.right  / 2) - (xWidth  / 2);
            Y = (rClient.bottom / 2) - (yHeight / 2);

            // Draw bounding rectangle.
            SelectObject (ps.hdc, hbrNull);
            Rectangle (ps.hdc, rClient.left, rClient.top,
                               rClient.right, rClient.bottom);

            // Adjust Rectangle for filling.
            rClient.left++;
            rClient.top ++;
            rClient.right --;
            rClient.bottom--;

            // Change from 'percent full' to 'percent empty'.
            iPercent = 100 - iPercent;

            /*
             * Calculate rectangles.
             *
             *     -----------------   Bottom of rPlain is
             *     |               |   same as top of rOpaque.
             *     |    rPlain     |            |
             *     |               |            |
             *     |---------------| <----------|
             *     |               |
             *     |    rOpaque    |
             *     |               |
             *     |---------------|
             */
            rPlain  = rClient;
            rOpaque = rClient;
            rPlain.bottom = rOpaque.top =
                ((rClient.bottom - rClient.top) * iPercent) / 100;

            // Draw string, with plain rectangle first.
            SetBkColor (ps.hdc, RGB (255, 255, 255));
            SetTextColor (ps.hdc, RGB (255, 0, 0));
            ExtTextOut (ps.hdc, X, Y, ETO_OPAQUE | ETO_CLIPPED,
                        &rPlain, ach, cb, 0);

            // Draw string, with opaqued rectangle.
            SetBkColor (ps.hdc, RGB (255, 0, 0));
            SetTextColor (ps.hdc, RGB (255, 255, 255));
            ExtTextOut (ps.hdc, X, Y, ETO_OPAQUE | ETO_CLIPPED,
                        &rOpaque, ach, cb, 0);

            EndPaint (hwnd, &ps);
            }
            break;

        case WM_TIMER:
            InvalidateRect (hwnd1, NULL, FALSE);
            InvalidateRect (hwnd2, NULL, FALSE);
            break;

        default:
            return(DefWindowProc(hwnd,wMsg,wParam,lParam));
            break;
        }
    return 0L;
    }
