/*
 * WINDOWS ICON EXTRACTION UTILITY - HEADER FILE
 *
 * LANGUAGE : Microsoft C 6.0
 * TOOLKIT  : Windows 3.0 SDK
 * MODEL    : Medium
 * STATUS   : Operational
 *
 * 07/04/91 - Kevin P. Welch - initial creation.
 *
 */

/* standard data types */
typedef char				CHAR;		/* ch   : 8-bit signed integer */
typedef int					INT;		/* n    : signed integer */
typedef unsigned short	USHORT;	/* us   : 16-bit unsigned integer */
typedef unsigned long	ULONG;	/* ul   : 32-bit unsigned integer */
typedef int					HFILE;	/* hf   : DOS file handle */
typedef CHAR FAR *		LPSZ;		/* lpsz : pointer to z-string	*/

/* general programming extensions */
#define ID(x)           GetWindowWord(x,GWW_ID)
#define PARENT(x)       GetWindowWord(x,GWW_HWNDPARENT)
#define INSTANCE(x)     GetWindowWord(x,GWW_HINSTANCE)
#define WARNING(x,y)		MessageBox(x,y,"Icon Extractor",MB_OK|MB_ICONHAND);

/* dialog box definitions */
#define  ID_FILE			100		/* file name */
#define	ID_FILELIST		101		/* directory list */
#define	ID_ICONS			102		/* icon list */
#define	ID_OPEN			103		/* open file button */
#define	ID_COPY			104		/* copy icon button */
#define	ID_EXIT			105		/* exit button */
#define	ID_PATH			106		/* current directory path */
#define	ID_ABOUT			107		/* about button */

/**/

/*
 * ICON HANDLING DATA STRUCTURES
 *
 */

/* general definitions */
#define MAXLENGTH			128
#define ICONDATAHANDLE	"IconDataHandle"
#define ICONCLIPFMT		"IconClipFmt"

/* program specific types */
typedef struct {
	WORD			wIconType;
	WORD			wWidth;
	WORD			wHeight;
	BYTE			bPlanes;
	BYTE			bBitsPixel;
	HBITMAP		hbmANDbits;
	HBITMAP		hbmXORbits;
	LONG			lFilePos;
} ICON;

typedef ICON FAR * 		LPICON;

typedef struct {
	WORD			wArraySize;
	ICON			icIconArray[1];
} ICONDATA;

typedef ICONDATA FAR * 	LPICONDATA;

/* error codes for file handling functions */
#define  IDERR_SUCCESS				0
#define  IDERR_BASE					255
#define  IDERR_ALLOCFAIL			(IDERR_BASE+1)	
#define  IDERR_LOCKFAIL				(IDERR_BASE+2)
#define  IDERR_OPENFAIL				(IDERR_BASE+3)
#define  IDERR_READFAIL				(IDERR_BASE+4)
#define  IDERR_WINFUNCFAIL			(IDERR_BASE+5)
#define  IDERR_INVALIDPARAM		(IDERR_BASE+6)
#define  IDERR_FILETYPEBAD			(IDERR_BASE+7)	
#define  IDERR_EXETYPEBAD			(IDERR_BASE+8)	
#define  IDERR_WINVERSIONBAD		(IDERR_BASE+9)
#define  IDERR_RESTABLEBAD			(IDERR_BASE+10)
#define  IDERR_ICONBAD				(IDERR_BASE+11)
#define  IDERR_NOICONS				(IDERR_BASE+12)
#define  IDERR_ARRAYFULL			(IDERR_BASE+13)

/**/

/* 
 * FUNCTION PROTOTYPES
 *
 */

/* function prototypes for iconex01.c */
BOOL  FAR PASCAL CenterPopup( HWND, HWND );
BOOL	FAR PASCAL OpenExeFile( HWND, LPSTR );
BOOL  FAR PASCAL Dialog( HWND, LPSTR, FARPROC );
BOOL  FAR PASCAL AboutDlgFn( HWND, WORD, WORD, LONG );
BOOL  FAR PASCAL IconExDlgFn( HWND, WORD, WORD, LONG );

/* function prototypes for iconex02.c */
WORD  FAR PASCAL IconExtract( LPSZ, LPHANDLE, LPWORD );
WORD  FAR PASCAL IconFree( HANDLE );
WORD  FAR PASCAL IconCreateIcon( HWND, HANDLE, WORD, LPHANDLE );
WORD  FAR PASCAL IconGetIconDescrip( HANDLE, WORD, LPSZ );
WORD  FAR PASCAL IconCopyToClipboard( HWND, HANDLE, WORD, WORD );

