/***************************************************************************
 *  COMMON.H								   *
 *	This file contains common declarations				   *
 *									   *
 *									   *
 *	  ClearNcb () - Clears a NCB					   *
 *									   *
 *  History:	Alok Sinha  October, 1991    Created			   *
 *									   *
 ***************************************************************************/

#ifndef COMMON_INCLUDED
#define COMMON_INCLUDED

#ifndef NETNCB_INCLUDED
#include <ncb.h>
#endif

void	       ClearNcb       ( NCB far *pNcb);
unsigned char  NetBiosRequest ( NCB far *pNcb);
int	       NetInit	      ( unsigned char ucLana);
int	       NetCleanUp     ( int Result);

// Common Defines
#ifndef NO_ERROR
#define NO_ERROR  0
#endif

#ifndef ERROR_INVALID_PARAMETER
#define ERROR_INVALID_PARAMETER 87
#endif

#ifndef BOOL
#define BOOL unsigned short
#define TRUE   0
#define FALSE  1
#endif

#define NETBIOS_CALL  0x5C

#endif /*  COMMON_INCLUDED  */
