'==============================================================================
'=
'= FILETST.INC  Copyright (C) 1991-1992 Microsoft Corporation
'=              Portions Copyright 1992, Daniel A. Norton
'=
'==============================================================================


' The File menu items.
Const M_FILEMENU   = "&File"
Const M_NEW	   = "&New"
Const M_OPEN	   = "&Open..."
Const M_SAVE	   = "&Save"
Const M_SAVEAS	   = "Save &As..."
Const M_SAVEALL    = "Save All"
Const M_CLOSE	   = "&Close"
Const M_EXIT	   = "E&xit"
Const M_PRINT	   = "&Print..."
Const K_NOSAVE	   = "%n"
Const K_SAVEFILE   = "%y"

'Print and Printer Setup items.
Const B_SETUP	   = "&Setup..."
Const B_OPTIONS    = "&Options..."
Const PS_PRINTER   = "&Printer:"

' File.SaveAs dialog items.
Const CM_FILE_NAME = "File &Name:"
Const LB_FILE_TYPE = "File Save as &Type:"


' File.Save(As) error return codes.
Const  FS_NO_ERROR	    = 0  ' File close. No save was necessary.
Const  FS_NO_ERR_SAVED	    = 1  ' File was saved, no errors.
Const  FS_INVALID_FILE_NAME = 2  ' Saved with invalid file name.
Const  FS_INVALID_PATH	    = 3  ' Attempt to save to invalid path.
Const  FS_INVALID_DRIVE     = 4  ' Attempt to save to invalid drive.
Const  FS_READ_ONLY_FILE    = 5  ' Attempt to save a read-only file.
Const  FS_CANT_CREATE_FILE  = 6  ' Can't create the file (i.e. save on read-only drive.
Const  FS_EMPTY_FILE	    = 7  ' The File.SaveAs menu is grayed since the file is empty.
Const  FS_RESERVED_NAME     = 8  ' Name is reserved (e.g. AUX, LPT1)
Const  FS_ERROR 	    = 9  ' Unexected error.

Declare Sub FileNew()
Declare Sub FileOpen(WTDFile$)
Declare Sub FileSave(FileName$, Method%)
Declare Sub FileSaveAll(Method%)
Declare Sub FileClose(YesNoCancel$, sMethod%)
Declare Sub FileExit(YesNoCancel$)

Declare Function FileSaveAs   (FileName$,  OKCancel$,	sMethod%, Replace%) As Integer
Declare Function FileCloseSave(FileName$, YesNoCancel$, sMethod%, Replace%) As Integer
Declare Function FileExitSave (FileName$, YesNoCancel$, sMethod%, Replace%) As Integer


'= Internally called functions, not for use by scripts.
Declare Function SaveFile (FileName$, YesNoCancel$, sMethod%, Replace%) As Integer
Declare Function SaveFailed (FileName As String) As Integer

'=
'=
'=
Sub FileNew() Static
    MenuCommand USE_KEYBOARD, M_FILEMENU, M_NEW, "%FN"
End Sub

'=
'=
'=
Sub FileOpen(WTDFile$) Static
   MenuCommand USE_KEYBOARD, M_FILEMENU, M_OPEN, "%FO"
   DoKeys WTDFile$
   DoKeys K_ENTER
End Sub

'=
'= FileSave: Save a file where you are sure no errors will occur.
'=           Method% indicates to use the keyboard or menu.
'=
Sub FileSave(FileName$, Method%) Static
    MenuCommand sMethod, M_FILEMENU, M_SAVE, K_F12
End Sub

'=
'= FileSaveAll:
'=
Sub FileSaveAll(Method%) Static
    MenuCommand sMethod, M_FILEMENU, M_SAVEALL, "%FV"
End Sub


'=
'= FileClose: Closes the file.  YesNoCancel$ specifies the keystrokes
'=            to send if the file is dirty.  sMethod% indicates, use
'=            the keyboard or use the menus.
'=            This sub is for closing files where you are certain
'=            no errors will occur on the close.
Sub FileClose(YesNoCancel$, sMethod%) Static
    MenuCommand sMethod, M_FILEMENU, M_CLOSE, "^{F4}"
    If WFndWndC("Save changes in", "STATIC", FW_PART Or FW_ACTIVE) Then
       DoKeys YesNoCancel
    End If
End Sub


'=
'= FileCloseSave: Closes the file.  If YesNoCancel is K_YES, then
'                 the file is saved as FileName$ if the file
'=                has been changed since the last save.
'= Return codes:  See the return codes and comments in
'=                the main FILE_SUBS section above.
'=            This function is for closing files where you need to
'=            determine what special conditions occurred during
'=            the close.
'=
Function FileCloseSave(FileName$, YesNoCancel$, sMethod%, Replace%) Static As Integer
    FileCloseSave = FS_NO_ERROR ' default return value if none others are set.
    MenuCommand sMethod, M_FILEMENU, M_CLOSE, K_CTRL+K_F4
    FileCloseSave = SaveFile(FileName$, YesNoCancel$, sMethod%, Replace%)
End Function


'=
'= FileSaveAs:    Saves the file as the given filename$.
'=                OKCancel -- the keys necessary to hit
'=                the OK button or the
'=                cancel button (usually ENTER or ESC).
'=                SMethod% -- keyboard or menu. Replace% is a boolean
'=                to indicate whether or not to save over an existing.
'=                file.
'=
'= Return codes:  See the return codes and comments in
'=                the main FILE_SUBS section above.
'=            This function is for closing files where you need to
'=            determine what special conditions occurred during
'=            the close.
'=
Function FileSaveAs(FileName$, OKCancel$, sMethod%, Replace%) Static As Integer
    DIM hWnd1 As Integer, hWnd2 As Integer

    FileSaveAs = FS_NO_ERR_SAVED ' default return value if none others are set.
    WMenu M_FILEMENU
    If WMenuGrayed(M_SAVEAS) = TRUE Then
       FileSaveAs = FS_EMPTY_FILE
       Exit Function
    End If

    WMenuEnd

    MenuCommand sMethod, M_FILEMENU, M_SAVEAS, K_SHIFT+K_F12


    FWFlags% = FW_PART OR FW_PART OR FW_NOCASE OR FW_NOFOCUS

    DoKeys FileName$ + K_ENTER

    ' Commdlg.DLL has two possible messages.
    hWnd1 = WFndWndC("Replace existing file", LABEL_CLASS, FWFlags%)
    hWnd2 = WFndWndC("Overwrite existing file", LABEL_CLASS, FWFlags%)

    If (hWnd1 <> 0) OR (hWnd2 <> 0) Then ' The file already exists.
	If Replace% = TRUE Then ' If the user indicated "replace".
            DoKeys K_YES
            FileSaveAs = FS_NO_ERR_SAVED ' Return value
                                         ' if none others are set.
	Else
            DoKeys K_NO + K_ESC
            FileSaveAs = FS_NO_ERROR ' Return value if none others are set.
	End If

    End If

    FileSaveAs = SaveFailed (FileName$)

    hWnd1 = WFndWnd("Save As", FW_DEFAULT)
    ' If so, DoKeys in the given file name, and check if an error occurs.
    If hWnd1 <> 0 Then ' Case where the file has not been saved before.
        FileSaveAs = FS_ERROR
        DoKeys K_ESC
    End If

End Function


'=
'= SaveFile: Closes the file.  If YesNoCancel is K_YES, then
'                 the file is saved as FileName$ if the file
'=                has been changed since the last save.
'= Return codes:  See the return codes and comments in
'=                the main FILE_SUBS section above.
'=            This function is for closing files where you need to
'=            determine what special conditions occurred during
'=            the close.
'= Used By:   FileCloseSave, FileExitSave, FileSaveAs
'=

Function SaveFile (FileName$, YesNoCancel$, sMethod%, Replace%) Static As Integer

    SaveFile = FS_NO_ERROR
    FWFlags% = FW_PART OR FW_ALL OR FW_NOCASE OR FW_NOFOCUS
    hWnd = WFndWndC("Would you like to save the changes made in", LABEL_CLASS, FWFlags%)
    If hWnd <> 0 Then ' If the file is dirty.
	DoKeys YesNoCancel
	If YesNoCancel = K_YES Then
	    ' Check if it's a read-only file.
	    hWnd = WFndWndC("' is read-only", LABEL_CLASS, FWFlags%)
	    If hWnd <> 0 Then ' If the file is read-only.
		DoKeys K_ENTER
		SaveFile = FS_READ_ONLY_FILE ' Return read-only code.
		Exit Function
	    End If
	    ' Check if the file is a new file never saved before.
	    hWnd = WFndWnd("Save As", FW_DEFAULT)
	    ' If so, DoKeys in the given file name, and check if an error occurs.
	    If hWnd <> 0 Then ' Case where the file has not been saved before.
		' Check if the file already exists.
		DoKeys FileName$ + K_ENTER
		hWnd = WFndWndC("Replace existing file?", LABEL_CLASS, FWFlags%)
		If hWnd <> 0 Then ' The file already exists.
		    If Replace% = TRUE Then ' If the user indicated "replace".
			DoKeys K_YES
		    Else
			DoKeys K_NO + K_ESC
		    End If
		End If
	    End If
	     SaveFile = SaveFailed (FileName$)
	Else
	    hWnd = WFndWnd("Save As", FW_DEFAULT)
	    ' If so, DoKeys in the given file name, and check if an error occurs.
	    If hWnd <> 0 Then ' Case where the file has not been saved before.
		SaveFile = FS_ERROR
		DoKeys K_ESC
	    End If
	End If
    End If

End Function



'= FileExit: YesNoCancel$ should be the keystrokes to respond if the file
'=           hasn't been saved.
'=           Use this SUB only if you are sure no errors will occur and
'=           that saving the file will not bring up the SaveAs dialog.
'=
Sub FileExit(YesNoCancel$) Static
    MenuCommand USE_KEYBOARD, M_FILEMENU, M_EXIT, "%FX"
    While WFndWndC("Save changes in", "STATIC", FW_PART Or FW_ACTIVE)
        DoKeys YesNoCancel
    WEnd
End Sub

'= FileExitSave.
'=    IF YesNoCancel$ = K_YES, then the file will be saved at whatever
'=    the default name path and drive currently are.  If an error occurs
'=    and the file can't be saved, the contents will be lost.
'=
Function FileExitSave(FileName$, YesNoCancel$, sMethod%, Replace%) Static As Integer
    FileExitSave = FS_NO_ERROR ' default return value if none others are set.
    MenuCommand sMethod, M_FILEMENU, M_EXIT, "%FX"
    FileExitSave = SaveFile(FileName$, YesNoCancel$, sMethod%, Replace%)
End Function

'========================================================================================
'= SaveFailed
'=     Returns a code indicating if the
'=     File.Save or File.SaveAs operation succeeded or failed.
'=     It cancels the Save As dialog if found.
'=
'=     This routine should really only be called by one of the File functions above.
'=     0 - No error occurred.
'=     1 - invalid file name
'=     2 - invalid path
'=     3 - invalid drive
'=     4 - read-only file
'=     5 - can't create/access the file
'=         (for example, save to a read-only drive)
'=
'=
'========================================================================================
Function SaveFailed (FileName As String) Static As Integer
   ' Check for the failure dialog box.

   SaveFailed = FS_NO_ERR_SAVED

   FWFlags% = FW_NOCASE OR FW_PART OR FW_ALL OR FW_NOFOCUS

   ' invalid file name.
   hWnd = WFndWndC("This filename is not valid.", "Static", FWFlags%)
   If hWnd <> 0 Then
       SaveFailed = FS_INVALID_FILE_NAME
   End If

   ' Invalid path error.
   hWnd = WFndWndC("Path does not exist.", LABEL_CLASS, FWFlags%)
   If hWnd <> 0 Then
      SaveFailed = FS_INVALID_PATH
   End If

   ' Read-only file.
   hWnd = WFndWndC("' is read-only", LABEL_CLASS, FWFlags%)
   If hWnd <> 0 Then
      SaveFailed = FS_READ_ONLY_FILE
   End If

   ' Read-only drive (or wrong priliges on the drive).
   hWnd = WFndWndC("Cannot access this file.", LABEL_CLASS, FWFlags%)
   If hWnd <> 0 Then
       SaveFailed = FS_CANT_CREATE_FILE
   End If

   ' Read-only drive (or wrong priliges on the drive).
   hWnd = WFndWndC("This filename is a reserved device name.", LABEL_CLASS, FWFlags%)
   If hWnd <> 0 Then
       SaveFailed = FS_RESERVED_NAME
   End If

   DoKeys K_ESC + K_ESC   ' Get rid of the dialog box.

End Function
