1           v                                                                                                         /* 
TINYSEGS.C -- Tests segment base addresses in Windows 
(and thus, segment/page relationship in Enhanced mode)
Microsoft Systems Journal, December 1992
Andrew Schulman
*/

/* TINYSEG.C */

#include <stdlib.h>
#include <string.h>
#include "windows.h"

#ifdef __cplusplus
extern "C" {
#endif  
extern DWORD FAR PASCAL GetSelectorBase(WORD wSel);
extern DWORD FAR PASCAL GetSelectorLimit(WORD wSel);
#ifdef __cplusplus
}
#endif  

static char buf[1024] = {0};

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, 
    LPSTR lpCmdLine, int nCmdShow)
{
    char tmp_buf[128];
    char far *fp;
    HANDLE h;
    char far *flagname;
    WORD flag;
    int i;
    
    DWORD size = 0x100;     // default 100h bytes
    if (*lpCmdLine)
    {
        lstrcpy(tmp_buf, lpCmdLine);
        size = atoi(tmp_buf);
    }
    
    for (i=0; i<15; i++)
    {
        if (i<5) { flag = GMEM_FIXED; flagname = "FIX"; }
        else if (i<10) { flag = GMEM_MOVEABLE; flagname = "MOVE"; }
        else if (i<15) { flag = GMEM_DISCARDABLE; flagname = "DISCARD"; }

        if (! (h = GlobalAlloc(flag, size)))
            break;
        if (! (fp = GlobalLock(h)))
            break;
        *fp = 'x';  // touch the memory
            
        wsprintf(tmp_buf, "%04X (%s)\t%08lX\t%04lX\n", 
            h, flagname,
            GetSelectorBase(h), GetSelectorLimit(h));
        strcat(buf, tmp_buf);
    }
    
    MessageBox(NULL, buf, "TINYSEGS", MB_OK);
    return 0;
}
?     v  w       v                                                                                                      ,                 0  4  6  G  I  ^  s              "  6  9   9  C  E  c  e                ,  8  >  q                      ;            4  H  q        	  (  /  5  d   d  s  v  x  ;            4  H  q        	  (  /  5  d      Arial   ndows.h"

#ifdef __cplusplus
extern "C" {
#endif  
extern DWORD FAR PASCAL GetSelectorBase(WORD wSel);
extern