/* ----------------------------- COMMDEFS.H --------------------------------
       Copyright (c) Spark Software Inc. 1990-1992.  All rights reserved.
   ------------------------------------------------------------------------- */

/* Scope definitions. */
#if !defined( PUBLIC ) || !defined( INITMODULE )
#   if defined( PUBLIC )
#       undef PUBLIC
#   endif
#   define PUBLIC               extern
#endif
#define PRIVATE                 static

/* Operating system dependent definitions. */
#ifdef MSDOS

#   ifdef MAX_BASENAME_LENGTH
#       undef MAX_BASENAME_LENGTH
#   endif
#   define MAX_BASENAME_LENGTH          12

#   ifdef _MAX_PATH
#       undef _MAX_PATH
#   endif
#   define _MAX_PATH                    127

#endif

/* Strings. */
#define CLIENT_APP_NAME                 "DDEML Demo Client"
#define SERVER_APP_NAME                 "DDEML Demo Server"

/* Stringtable constants. */
/* NOTE: IDS_* must be less than DMLERR_FIRST. */
#define IDS_FIRST                       1000
#define IDS_UNKNOWN_ERROR               (IDS_FIRST)
#define IDS_CANT_INITIALIZE_APP         (IDS_FIRST + 1)
#define IDS_CANT_RUN_FIND_DLG           (IDS_FIRST + 2)
#define IDS_SUPPLY_DELAY_VALUE          (IDS_FIRST + 3)
#define IDS_SUPPLY_TIMEOUT_VALUE        (IDS_FIRST + 4)
#define IDS_CANNOT_GET_FILENAME         (IDS_FIRST + 5)
#define IDS_CANNOT_OPEN_FILE            (IDS_FIRST + 6)
#define IDS_NO_MEM_ALLOC                (IDS_FIRST + 7)
#define IDS_NO_MEM_LOCK                 (IDS_FIRST + 8)
#define IDS_CANNOT_DISPLAY_FILE         (IDS_FIRST + 9)
#define IDS_CANNOT_SEARCH_FILE          (IDS_FIRST + 10)
#define IDS_CANNOT_ALLOCATE_MEMORY      (IDS_FIRST + 11)
#define IDS_CANNOT_LOCK_MEMORY          (IDS_FIRST + 12)
#define IDS_CANNOT_CREATE_WIN           (IDS_FIRST + 13)
#define IDS_EXPLAIN_TOPICS              (IDS_FIRST + 14)
#define IDS_EXPLAIN_SYSITEMS            (IDS_FIRST + 15)
#define IDS_EXPLAIN_RTNMSG              (IDS_FIRST + 16)
#define IDS_EXPLAIN_STATUS              (IDS_FIRST + 17)
#define IDS_EXPLAIN_FORMATS             (IDS_FIRST + 18)
#define IDS_INVALID_PATH                (IDS_FIRST + 19)

/* DDE constants. */
#define STD_SYNC_TIMEOUT                2000

/* Topics and Items. */
#define TOPIC_SEARCH                    "Search"
#define ITEM_CONFIGURE                  "Configure"
#define ITEM_FIND                       "Find"

/* Misc. definitions. */
#define MAX_SEARCH_STRING_LENGTH        31
#define SF_CONTINUOUS                   (1<<0)
#define SF_XMIT_TO_PROGMAN              (1<<1)

/* Macros. */
#define DO_DIALOG( p , n , i , w , l )                              \
{                                                                   \
    DLGPROC lpfnProc;                                               \
                                                                    \
                                                                    \
    lpfnProc = (DLGPROC)MakeProcInstance( (FARPROC)p , i );         \
    DialogBoxParam( i , MAKEINTRESOURCE( n ) , w , lpfnProc , l );  \
    FreeProcInstance( (FARPROC)lpfnProc );                          \
    SetFocus( w );                                                  \
}

#define HandleDDEMLError( c , r , v )       \
if( !(c) )                                  \
{                                           \
    if( wDDEMLError != DMLERR_NO_ERROR )    \
    {                                       \
        ErrorMsg( (UINT)wDDEMLError );      \
    }                                       \
    if( r )                                 \
    {                                       \
        return v;                           \
    }                                       \
}

/* Type definitions. */
typedef BOOL FAR * LPBOOL;
typedef UINT FAR * LPUINT;
typedef GLOBALHANDLE FAR * LPGLOBALHANDLE;
typedef HDDEDATA CALLBACK SERVERACTION( UINT wType , UINT wFmt , HCONV hConv ,
        HSZ hsz1 , HSZ hsz2 , HDDEDATA hData , DWORD dwData1 , DWORD dwData2 ,
        LPVOID lpExtraParms );
typedef SERVERACTION FAR *LPSERVERACTION;

typedef struct ItemInfoTag
{
    LPSTR          lpszItem;
    HSZ            hszItem;
    LPSERVERACTION lpServerAction;
}
ITEMINFO;
typedef ITEMINFO FAR *LPITEMINFO;

typedef struct TopicInfoTag
{
    LPSTR      lpszTopic;
    HSZ        hszTopic;
    LPITEMINFO lpItemInfo;
}
TOPICINFO;
typedef TOPICINFO FAR *LPTOPICINFO;

typedef struct SearchStringInfoTag
{
    HCONV hConv;
    BYTE  szSearchString[ MAX_SEARCH_STRING_LENGTH + 1 ];
}
SEARCHSTRINGINFO;
typedef SEARCHSTRINGINFO FAR *LPSEARCHSTRINGINFO;

typedef struct FoundFileInfoTag
{
    HCONV hConv;
    BYTE  szFoundFileName[ _MAX_PATH + 1 ];
}
FOUNDFILEINFO;
typedef FOUNDFILEINFO FAR *LPFOUNDFILEINFO;

typedef struct OpenFileErrInfoTag
{
    int   nErrCode;
    LPSTR lpszErrMsg;
}
OPENFILEERRINFO;

/* EOF */
