/*
  PLAYBG.C function, Copyright 1990,91 by A.A.Efros.
  This function is a part of MELODY MASTER v2.1 Programmer Support Files.
  It is used to play *background* music in C language. The music is
  generated using MELODY MASTER's output to "C bck-gr". This routine
  makes use of a great Public Domain program SoudSys.C!

  INSTRUCTIONS:
    1. Run MELODY MASTER main program (MM.EXE or MMCGA.EXE).
    2. Load (F3) the melody you want.
    3. Output (F7) the melody choosing "C bck-gr" option.
    4. Exit MELODY MASTER (Alt-X).
    5. Edit this file so the include statement {#include ...} will have
       the name of your music file.
    6. #include "playbg.c" file in YOUR program.
    7. When you want the music to be played, call play_backgound()
       function (dont't forget to put your foreground code in the
       play_backgound() function).

  NOTE: For more detailed information about this routine, please, see
	SOUNDSYS.C file.
*/


#include "soundsys.c"
#include "filename.c" /* <----- Insert the name of your music file here!   */
void play_background()
{
  int i;

  init_sound();
  back_sound = OFF;

  for (i=0;i<MAX;i++)
  {
    submit_sound(melody[i][0],melody[i][1]);
  }
/*
  . . . Put your foreground code here . . .
*/

  getch();        /* You may take this away */
  restore_sound();
}
