/*
*    keymap.h
*  Used for Keyboard mapping things
****************************************************************************
*                                                                          *
*                                                                          *
*      NCSA Telnet                                                         *
*      by Tim Krauskopf, VT100 by Gaige Paulsen, Tek by Aaron Contorer     *
*			Additions by Kurt Mahan, Heeren Pathak, & Quincey Koziol	   *
*                                                                          *
*      National Center for Supercomputing Applications                     *
*      152 Computing Applications Building                                 *
*      605 E. Springfield Ave.                                             *
*      Champaign, IL  61820                                                *
*                                                                          *
****************************************************************************
*	Quincey Koziol
*   Defines for keyboard mapping variables
*/

#ifndef KEYMAP_H

typedef struct key_node_struct {	/* structure to hold nodes in the keyboard mapping linked list */
	unsigned int key_code;			/* the key code this node re-maps */
	union {
		char *key_str;				/* pointer to the re-mapping string for this key */
		unsigned char vt100_code;	/* vt100 code generated by this key */
	  }	key_data;					/* union to hold pointer to string or vt100 code */
	struct key_node_struct *next_node;	/* pointer to the next node in the keyboard mapping list */
  } key_node;

/* Macros to access the mapped & special flags for any key code */
/* -------------------------------------------------------------*/
/* macro to return whether a key code is mapped */
#define IS_KEY_MAPPED(x)	((key_map_flags[(int)(x/8)]&(0x0001<<(x%8)))>0)

/* macro to return whether a key code is special (i.e. kermit verb) */
#define IS_KEY_SPECIAL(x)	((key_special_flags[(int)(x/8)]&(0x0001<<(x%8)))>0)

/* macro to reset the mapped flag for a key code */
#define RESET_KEY_MAPPED(x)	(key_map_flags[(int)(x/8)]=key_map_flags[(int)(x/8)]&(unsigned char)(~(0x0001<<(x%8))))

/* macro to reset the special flag for a key code */
#define RESET_KEY_SPECIAL(x)	(key_special_flags[(int)(x/8)]=key_special_flags[(int)(x/8)]&(unsigned char)(~(0x0001<<(x%8))))

/* macro to set the mapped flag for a key code */
#define SET_KEY_MAPPED(x)	(key_map_flags[(int)(x/8)]=key_map_flags[(int)(x/8)]|(unsigned char)(0x0001<<(x%8)))

/* macro to set the special flag for a key code */
#define SET_KEY_SPECIAL(x)	(key_special_flags[(int)(x/8)]=key_special_flags[(int)(x/8)]|(unsigned char)(0x0001<<(x%8)))


#ifdef KEYMASTER
key_node *head_key=NULL;		/* head of the key node list */

/* array of unsigned chars which are really used as bits for flags to indicate */
/*	that a key has been re-mapped */
unsigned char key_map_flags[1024];

/* array of unsigned chars which are really used as bits for flags to indicate */
/*	that a key is a special key (i.e. used for a kermit verb) */
unsigned char key_special_flags[1024];
#else
extern key_node *head_key;		/* head of the key node list */

/* array of unsigned chars which are really used as bits for flags to indicate */
/*	that a key has been re-mapped */
extern unsigned char key_map_flags[1024];

/* array of unsigned chars which are really used as bits for flags to indicate */
/*	that a key is a special key */
extern unsigned char key_special_flags[1024];
#endif

#define KEYMAP_H
#endif	/* keymap.h */

