#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <math.h>
#include <malloc.h>
#include <string.h>

#include "vskeys.h"

#define MAX_LINE_LENGTH		160

typedef unsigned char byte;
typedef unsigned int uint;

static void read_keyboard_file(char *key_file);
static char *parse_str(char *file_str,uint *ret_code);
static int parse_verb(char *verb_str,uint *ret_code);

static char white_sp[]="\x009\x00a\x00b\x00c\x00d\x020";	/* string which contains all the white space characters */
static char end_token[]="\x000\x009\x00a\x00b\x00c\x00d\x020};";	/* string which contains all the white space characters, and the right curley brace & the semi-colon */

static int parse_verb(char *verb_str,uint *ret_code)
{
	if(!strnicmp(verb_str,"null",4)) {		/* check for sending NULL (0) character */
		*ret_code=0;		/* indicate NULL character */
		return(4);			/* indicate the number of characters to skip */
	  }	/* end if */
	else if(!strnicmp(verb_str,"gold",4)) {	/* check for vt102 function key f1 */
		*ret_code=VSF1;		/* indicate f1 character */
		return(4);			/* indicate the number of characters to skip */
	  }	/* end if */
	else if(!strnicmp(verb_str,"pf1",3)) {	/* check for vt102 function key f1 */
		*ret_code=VSF1;		/* indicate f1 character */
		return(3);			/* indicate the number of characters to skip */
	  }	/* end if */
	else if(!strnicmp(verb_str,"pf2",3)) {	/* check for vt102 function key f2 */
		*ret_code=VSF2;		/* indicate f2 character */
		return(3);			/* indicate the number of characters to skip */
	  }	/* end if */
	else if(!strnicmp(verb_str,"pf3",3)) {	/* check for vt102 function key f3 */
		*ret_code=VSF3;		/* indicate f3 character */
		return(3);			/* indicate the number of characters to skip */
	  }	/* end if */
	else if(!strnicmp(verb_str,"pf4",3)) {	/* check for vt102 function key f4 */
		*ret_code=VSF4;		/* indicate f4 character */
		return(3);			/* indicate the number of characters to skip */
	  }	/* end if */
	else if(!strnicmp(verb_str,"kp0",3)) {	/* check for vt102 keypad numeric keys */
		*ret_code=VSK0;		/* indicate keypad character */
		return(3);			/* indicate the number of characters to skip */
	  }	/* end if */
	else if(!strnicmp(verb_str,"kp1",3)) {	/* check for vt102 keypad numeric keys */
		*ret_code=VSK1;		/* indicate keypad character */
		return(3);			/* indicate the number of characters to skip */
	  }	/* end if */
	else if(!strnicmp(verb_str,"kp2",3)) {	/* check for vt102 keypad numeric keys */
		*ret_code=VSK2;		/* indicate keypad character */
		return(3);			/* indicate the number of characters to skip */
	  }	/* end if */
	else if(!strnicmp(verb_str,"kp3",3)) {	/* check for vt102 keypad numeric keys */
		*ret_code=VSK3;		/* indicate keypad character */
		return(3);			/* indicate the number of characters to skip */
	  }	/* end if */
	else if(!strnicmp(verb_str,"kp4",3)) {	/* check for vt102 keypad numeric keys */
		*ret_code=VSK4;		/* indicate keypad character */
		return(3);			/* indicate the number of characters to skip */
	  }	/* end if */
	else if(!strnicmp(verb_str,"kp5",3)) {	/* check for vt102 keypad numeric keys */
		*ret_code=VSK5;		/* indicate keypad character */
		return(3);			/* indicate the number of characters to skip */
	  }	/* end if */
	else if(!strnicmp(verb_str,"kp6",3)) {	/* check for vt102 keypad numeric keys */
		*ret_code=VSK6;		/* indicate keypad character */
		return(3);			/* indicate the number of characters to skip */
	  }	/* end if */
	else if(!strnicmp(verb_str,"kp7",3)) {	/* check for vt102 keypad numeric keys */
		*ret_code=VSK7;		/* indicate keypad character */
		return(3);			/* indicate the number of characters to skip */
	  }	/* end if */
	else if(!strnicmp(verb_str,"kp8",3)) {	/* check for vt102 keypad numeric keys */
		*ret_code=VSK8;		/* indicate keypad character */
		return(3);			/* indicate the number of characters to skip */
	  }	/* end if */
	else if(!strnicmp(verb_str,"kp9",3)) {	/* check for vt102 keypad numeric keys */
		*ret_code=VSK9;		/* indicate keypad character */
		return(3);			/* indicate the number of characters to skip */
	  }	/* end if */
	else if(!strnicmp(verb_str,"kpdot",5)) {	/* check for other vt102 keypad keys */
		*ret_code=VSKP;		/* indicate keypad character */
		return(5);			/* indicate the number of characters to skip */
	  }	/* end if */
	else if(!strnicmp(verb_str,"kpminus",7)) {	/* check for other vt102 keypad keys */
		*ret_code=VSKM;		/* indicate keypad character */
		return(7);			/* indicate the number of characters to skip */
	  }	/* end if */
	else if(!strnicmp(verb_str,"kpcoma",6)) {	/* check for other vt102 keypad keys */
		*ret_code=VSKC;		/* indicate keypad character */
		return(6);			/* indicate the number of characters to skip */
	  }	/* end if */
	else if(!strnicmp(verb_str,"kpenter",7)) {	/* check for other vt102 keypad keys */
		*ret_code=VSKE;		/* indicate keypad character */
		return(7);			/* indicate the number of characters to skip */
	  }	/* end if */
	else if(!strnicmp(verb_str,"uparr",5)) {	/* check for vt102 cursor (arrow) keys */
		*ret_code=VSUP;		/* indicate cursor key */
		return(5);			/* indicate the number of characters to skip */
	  }	/* end if */
	else if(!strnicmp(verb_str,"dnarr",5)) {	/* check for vt102 cursor (arrow) keys */
		*ret_code=VSDN;		/* indicate cursor key */
		return(5);			/* indicate the number of characters to skip */
	  }	/* end if */
	else if(!strnicmp(verb_str,"lfarr",5)) {	/* check for vt102 cursor (arrow) keys */
		*ret_code=VSLT;		/* indicate cursor key */
		return(5);			/* indicate the number of characters to skip */
	  }	/* end if */
	else if(!strnicmp(verb_str,"rtarr",5)) {	/* check for vt102 cursor (arrow) keys */
		*ret_code=VSRT;		/* indicate cursor key */
		return(5);			/* indicate the number of characters to skip */
	  }	/* end if */
	else {			/* indicate that we recognize this kermit verb */
		*ret_code=0xFFFF;		/* indicate that we don't recognize this verb */
		return(strcspn(verb_str,end_token));	/* return the number of characters to skip */
	  }	/* end else */
}	/* end parse_verb() */

static char *parse_str(char *file_str,uint *ret_code)
{
	int buff_off=0,			/* current location in the buffer */
		ascii_num,			/* ascii character encoded after a backslash */
		kermit_length,		/* the length of a kermit verb returned from parsing it */
		done=0;				/* flag for dropping out of the loop */
	byte *ret_str,			/* the string variable to return the result in */
		*temp_str,			/* pointer to the current place in the string */
		buffer[MAX_LINE_LENGTH];		/* buffer to store the string we are unravelling */

	*ret_code=0xFFFF;		/* mark return code to indicate nothing special to return */
	temp_str=file_str;		/* start at the beginning of the string to parse */
	while((*temp_str)!='\0' && buff_off<MAX_LINE_LENGTH && !done) {		/* parse until the end of the string or until the buffer is full */
		while((*temp_str) && (*temp_str)!=';' && (*temp_str)!='\\' && (*temp_str)!='{' && (*temp_str)>' ') {	/* copy regular characters until a special one is hit */
			buffer[buff_off]=(*temp_str);		/* copy the character */
			buff_off++;		/* increment the position in the buffer */
			temp_str++;		/* increment the position in the parse string */
		  }	/* end while */
		if(*temp_str) {		/* check on the various special cases for dropping out of the loop */
			switch(*temp_str) {		/* switch for the special case */
				case '\\':	/* backslash for escape coding a character */
					temp_str++;		/* get the character after the backslash */
					if((*temp_str)=='{') {	/* check for curly brace around numbers */
						temp_str++;	/* increment to the next character */
						if((*temp_str)=='K' || (*temp_str)=='k') {		/* check for Kermit escape code here also */
							temp_str++;		/* increment past the kermit flag */
							kermit_length=parse_verb(temp_str,ret_code);		/* parse the kermit verb, and return the correct kermit code in the ret_code */
							if(*ret_code!=0xFFFF)		/* a kermit verb was specified that we recognize */
								return(NULL);		/* return now, indicating a kermit verb we recognize in the ret_code variable */
							temp_str+=kermit_length;	/* increment past the kermit verb */
							if((*temp_str)=='}')	/* found the closing curly brace */
								temp_str++;		/* jump over the closing curly brace */
							else {		/* closing curly brace missing, indicate error */
								buff_off=0;
								done=1;
							  }	/* end else */
						  }	/* end if */
						else {		/* must be an escape integer */
							ascii_num=atoi(temp_str);	/* get the ascii number after the escape code */
							buffer[buff_off]=(byte)ascii_num;	/* store the ascii code in the buffer */
							buff_off++;				/* increment our position */
							if(ascii_num<10)		/* increment the parsing string once for numbers under ten */
								temp_str++;
							else if(ascii_num<100)	/* increment twice for numbers under 100 */
								temp_str+=2;
							else if(ascii_num<1000)	/* increment thrice for numbers under 1000 */
								temp_str+=3;
							else if(ascii_num<10000)	/* increment four times for numbers under 10000 (I know it should happen, but why take chances) */
								temp_str+=4;
							else		/* final, impossible case */
								temp_str+=5;
							if((*temp_str)=='}')	/* found the closing curly brace */
								temp_str++;		/* jump over the closing curly brace */
							else {		/* closing curly brace missing, indicate error */
								buff_off=0;
								done=1;
							  }	/* end else */
						  }	/* end else */
					  }	/* end if */
					else if((*temp_str)=='K' || (*temp_str)=='k') {		/* check for Kermit escape code */
						temp_str++;		/* increment past the kermit flag */
						kermit_length=parse_verb(temp_str,ret_code);		/* parse the kermit verb, and return the correct kermit code in the ret_code */
						if(*ret_code!=0xFFFF)		/* a kermit verb was specified that we recognize */
							return(NULL);		/* return now, indicating a kermit verb we recognize in the ret_code variable */
						temp_str+=kermit_length;	/* increment past the kermit verb */
					  }	/* end if */
					else {		/* must be an escape integer */
						ascii_num=atoi(temp_str);	/* get the ascii number after the escape flag */
						buffer[buff_off]=(byte)ascii_num;	/* store the ascii code in the buffer */
						buff_off++;				/* increment our position */
						if(ascii_num<10)		/* increment the parsing string once for numbers under ten */
							temp_str++;
						else if(ascii_num<100)	/* increment twice for numbers under 100 */
							temp_str+=2;
						else if(ascii_num<1000)	/* increment thrice for numbers under 1000 */
							temp_str+=3;
						else if(ascii_num<10000)	/* increment four times for numbers under 10000 (I know it should happen, but why take chances) */
							temp_str+=4;
						else		/* final, impossible case */
							temp_str+=5;
					  }	/* end else */
					break;

				case '{':	/* curly brace opens a quoted string */
					temp_str++;		/* jump over the brace itself */
					while((*temp_str) && (*temp_str)!='}') {	/* copy regular characters until a special one is hit */
						buffer[buff_off]=(*temp_str);		/* copy the character */
						buff_off++;		/* increment the position in the buffer */
						temp_str++;		/* increment the position in the parse string */
					  }	/* end while */
					if((*temp_str)=='}')		/* found the closing brace */
						temp_str++;		/* jump over the closing brace */
					else {		/* line terminated without closing brace */
						buff_off=0;		/* indicate error condition */
						done=1;			/* drop out of the loop */
					  }	/* end else */
					break;

				default:	/* ctrl character, space, & semi-colon terminate string */
#ifdef OLD_WAY
				case ' ':	/* space should end the parsing input */
				case ';':	/* so should semi-colon */
#endif
					buffer[buff_off]='\0';	/* terminate the string */
					done=1;
					break;

			  }	/* end switch */
		  }	/* end if */
		else
			buffer[buff_off]='\0';	/* terminate the string */
	  }	/* end while */
	if(buff_off>0) {
		ret_str=malloc(buff_off+1);
		strcpy(ret_str,buffer);		/* copy the parsed string */
		return(ret_str);
	  }	/* end if */
	return(NULL);
}	/* end parse_str() */

static void read_keyboard_file(char *key_file)
{
	FILE *key_fp;			/* pointer to the keyboard file */
	char key_line[MAX_LINE_LENGTH],		/* static array to store lines read from keyboard file */
		*map_str,			/* the parsed string from the keyboard file */
		*temp_str,*temp_2str;	/* temporary pointer to a string */
	uint line_no=0,			/* what line in the file we are on */
		token_num,			/* the current token we are parsing */
		where,				/* pointer to the beginning of text */
		kermit_code,		/* the variable to return the possible 'kermit verb' code in */
		re_map_key;			/* the key to re-map */

	if((key_fp=fopen(key_file,"rt"))!=NULL) {
		while((temp_str=fgets(key_line,MAX_LINE_LENGTH,key_fp))!=NULL) {	/* get a line of input */
			printf("\nline:%d, '%s\n",line_no,key_line);		/* print the line we just read */
			token_num=0;			/* initialize the token we are on */
			if((temp_str=strtok(key_line,white_sp))!=NULL) {	/* get the first token from the string */
				printf("first token=%s\n",temp_str);
				if((*temp_str)!=';') {		/* check for a comment line */
					do {
						printf("token #%d: '%s'\n",token_num,temp_str);
						switch(token_num) {		/* switch on which token we are processing */
							case 0:		/* the 'SET' token (we already know it is not a comment) */
								if(strcmp(temp_str,"SET") && strcmp(temp_str,"set")) {	/* make certain the first token is a SET token */
									printf("invalid token #%d:'%s' on line %d\n",token_num,temp_str,line_no);
									token_num=4;	/* bump the token count up to drop out of the loop */
								  }	/* end if */
								break;

							case 1:		/* the 'KEY' token */
								if(strcmp(temp_str,"KEY") && strcmp(temp_str,"key")) {	/* make certain the first token is a KEY token */
									printf("invalid token #%d:'%s' on line %d\n",token_num,temp_str,line_no);
									token_num=4;	/* bump the token count up to drop out of the loop */
								  }	/* end if */
								break;

							case 2:		/* the key to be re-mapped */
								if(!strcmp(temp_str,"CLEAR") || !strcmp(temp_str,"OFF") || !strcmp(temp_str,"ON") || (*temp_str)==';') {	/* ignore the rest of the line if the 'key' is one of the tokens we don't support */
									token_num=4;	/* bump the token count up to drop out of the loop */
								  }	/* end if */
								else {		/* the 'key' field is not a special command or a comment, must be a valid character */
									if(*(temp_str)!='\\') {	/* the key to re-map is not an escape code */
										re_map_key=*temp_str;	/* set the re-mapping key */
									  }	/* end if */
									else {
										re_map_key=atoi(temp_str+1);	/* get the re-mapping key value from the string */
										if(re_map_key==0) {		/* invalid key code */
											printf("Error, invalid key code:%s, on line %d\n",temp_str,line_no);
											token_num=4;	/* bump the token count up to drop out of the loop */
										  }	/* end if */
										else {
											printf("Key code to re-map=%d\n",re_map_key);
										  }	/* end else */
									  }	/* end else */
								  }	/* end else */
								break;

							case 3:		/* the string to re-map the key to */
								if((*temp_str)==';') {	/* ignore the rest of the line if the 'key' is one of the tokens we don't support */
									printf("Resetting definition for %d on line %d\n",re_map_key,line_no);
									token_num=4;	/* bump the token count up to drop out of the loop */
								  }	/* end if */
								else {
									if((map_str=parse_str(temp_str,&kermit_code))!=NULL) {		/* parse the re-mapping string */
										printf("parsed string=");
										temp_2str=map_str;
										while(!isprint(*temp_2str) && (*temp_2str)!='\0') {
											printf("\\%d",(int)*temp_2str);
											temp_2str++;
										  }	/* end while */
										printf("%s\n",temp_2str);
										free((char *)map_str);
									  }	/* end if */
									else {
										if(kermit_code!=0xFFFF) {	/* check for special kermit verb returned */
											printf("Kermit code:%u, on line %d\n",kermit_code,line_no);
										  }	/* end if */
										else {
											printf("Error, re-mapping string:%s invalid on line %d\n",temp_str,line_no);
											token_num=4;	/* bump the token count up to drop out of the loop */
										  }	/* end else */
									  }	/* end else */
								  }	/* end else */
								break;
						  }	/* end switch */
						token_num++;
						if(token_num<3)		/* if the next token is not the last one, then grab it */
							temp_str=strtok(NULL,white_sp);		/* get the next token */
						else if(token_num==3) {		/* for the last 'token' (after the remapping key to the end of the line), just get the next character in the line */
							temp_str+=(strlen(temp_str)+1);		/* jump over the previous token */
							where=strspn(temp_str,white_sp);	/* look for the first non-white space in the line */
							temp_str+=where;	/* jump to the first position with a character */
							if(where==0)
								printf("*temp_str=%d\n",(int)*temp_str);
							if(!isgraph(*temp_str)) {		/* not more characters in the line */
								printf("Truncated line, Resetting definition for %d on line %d\n",re_map_key,line_no);
								token_num=4;	/* bump the token count to drop out of the loop */
							  }	/* end if */
						  }	/* end if */
					  }	while(temp_str!=NULL && token_num<4);
				  }	/* end if */
				else {
					printf("Whole line is a comment\n");
				  }	/* end else */
			  }	/* end if */
			line_no++;			/* increment current line */
		  }	/* end while */
		fclose(key_fp);
	  }	/* end if */
}	/* end read_keyboard_file() */

int main(int argc,char *argv[])
{
	if(argc!=2) {
		printf("Usage:\nreadmap keyboard_file\n");
		return(1);
	  }	/* end if */
	read_keyboard_file(argv[1]);
	return(0);
}	/* end readmap() */
