/*
*   NCSA Telpass - edit password files for NCSA Telnet.
*   Tim Krauskopf 6/88
*
*   This program is rough-cut but functional.
*   If you improve it substantially, let me know.
*/
/************************************************************************/
#define PASS

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef MSC
#include <malloc.h>
#endif

#include "externs.h"
static void dochoice(int c);
static void noecho(char *s);
static void passwrite(char *s);
static void passlist(char *s);
static void Sencompass(char *ps);

void noecho();
void passwrite();
void Sencompass();

char space[256];
char space2[256],*p;
char *lines[200];

FILE *fout,*fin;
int nnames;

void main(argc,argv)
int argc;
char *argv[];
{
	int i,choice;

	nnames=0;
	n_clear();
	n_cur(0,0);
	n_puts("National Center for Supercomputing Applications");
	n_puts("Password file editor for NCSA Telnet\n");
	n_puts("Note:  This encryption of passwords is to hide clear text from casual viewing, ");
	n_puts("       not to protect them from decryption.  You must assume that anyone with");
	n_puts("       access to the password file can decrypt the passwords.\n");
	if(argc<2) {
		n_puts("A filename is required.  Usage: telpass filename");
		exit(0);
	  }
	passlist(argv[1]);
	do {
		n_puts("List of names:");
		for(i=0; i<nnames; i++) {
			sprintf(space,"%3d. %s",i+1,lines[i]);
			n_puts(space);
		  }
		n_puts("Enter the number of a user to change the password for,");
		n_puts("'a' to add a user, 'd #' to delete a user, 'e' to exit:");
		gets(space);
		n_row();
		choice=atoi(space);
		if(choice)
			dochoice(choice-1);
		else 
			if(*space=='a') {
				n_puts("Enter the username to add:");
				gets(space);
				n_row();
				lines[nnames] = malloc(strlen(space)+1);
				strcpy(lines[nnames++],space);
				dochoice(nnames-1);		/* get the password */
			  }
			else 
				if(*space=='d') {
					choice=atoi(space+1);
					if(choice<=nnames&&choice>0) {
						for (i=choice-1; i<nnames; i++)
						lines[i]=lines[i+1];		/* shuffle down */
						nnames--;
			  		  }
				  }
				else 
					if(*space=='e')
					choice = -1;
	  }while(choice>=0);
	passwrite(argv[1]);
	exit(0);
}

/****************************************************************************/
/* dochoice
*  prompt for a certain password
*/
static void dochoice(int c)
{
	char *p;
	char pwd[256],ver[256];

	strcpy(space,lines[c]);
	do{
		p=strchr(space,':');
		if(!p)
			strcat(space,":");
	  }while(!p);						/* make sure we get a : */
	*p='\0';
	p++;
	sprintf(space2,"Enter new password for user: %s",space);
	n_puts(space2);
	noecho(pwd);	
	n_puts("Verify password by entering again:");
	noecho(ver);
	if(strcmp(pwd,ver)) {
		n_puts("Password not verified");
		return;
	  }
	Sencompass(pwd);					/* take password */
	sprintf(ver,"%s:%s",space,space2);
	lines[c]=malloc(strlen(ver)+1);
	strcpy(lines[c],ver);
}

static void noecho(char *s)
{
	int c;

	do {
		c=n_getchar();
		if(c>31&&c<128)
			*s++= (char) c;
	}while(c>31&&c<128);
	*s='\0';
}

/****************************************************************************/
/* passwrite
*  write them out
*/
static void passwrite(char *s)
{
	int i;

	if(NULL==(fout=fopen(s,"w"))) {
		n_puts("Cannot open file to write passwords. ");
		exit(0);
	  }
	for(i=0; i<nnames; i++) {
		fputs(lines[i],fout);
		fputs("\n",fout);
	  }
	fclose(fout);
}

/****************************************************************************/
/*  passlist
*   List the current file
*/
static void passlist(char *s)
{
	if(NULL==(fin=fopen(s,"r"))) {
		n_puts("Starting new file.");
		return;
	  }
	while(NULL!=fgets(space,250,fin)) {
		space[strlen(space)-1]='\0';
		lines[nnames]=malloc(strlen(space)+1);
		strcpy(lines[nnames++],space);
	  }
	fclose(fin);
}

/****************************************************************************/
/* Scompass
*  compute and check the encrypted password
*/
static void Sencompass(char *ps)
{
	int i,ck;
	char *p,c,*en;

	en=space2;
	ck=0;
	p=ps;
	while(*p)				/* checksum the string */
		ck+=*p++;
	c=(char) ck;
	for(i=0; i<10; i++) {
		*en=(char) (((*ps ^ c)|32)&127); 	/* XOR with checksum */
		if(*ps)
			ps++;
		else
			c++;		/* to hide length */
		en++;
	  }
	*en=0;
}
