
{$ifdef windows}
uses wobjects,dyna2,nnunit,wincrt,cfmtools, bpnet;
{$else}
uses objects,dyna2,nnunit,crt,cfmtools, bpnet;
{$endif}

{$F+}
label stop;

const
     incount         = 2;
     hidecount       = 2;
     outcount        = 1;

var
   max          : longint;
   net          : psimpleBPnet;
   i,j,k        : longint;
   desiredmat   : pdynamat;
   inputmat     : pdynamat;
   errorvec     : pdynavec;
   invec        : pdynavec;
   desiredvec   : pdynavec;
   linelength   : integer;
   lines        : integer;
   totalerror   : double;
   lasterror    : double;
   num          : double;
   thisone      : pneuron;
   data     : text;
   log      : text;
   stuff    : string;
   learn    : double;
   count    : integer;
   momentum : double;
   kmod     : double;
   maxcount : integer;
   maxerr   : double;
   key      : char;
   io       : pdosstream;

{-----------------------------}
procedure printmattofile(var filevar: text; var mat: dynamat);
{-----------------------------}
var
   i,j          : integer;

begin
     for i := 1 to mat.nrow do
      begin
      for j := 1 to mat.ncol do write(filevar,mat.get(i,j):8:4 );
      writeln(filevar);
      end;
     writeln(filevar);
end;


{              ------------- Main -----------------}


begin
                                {Initialize stuff...}
     randomize;
     clrscr;
     max := memavail;

     opentextfile('xor.dat',data);
     if createtextfile('xor.log',log) <> 0 then halt(1);

                                   {count lines}

     readln(data,stuff);
     writeln(log,stuff);
     readln(data,lines,learn,momentum,kmod,maxerr,maxcount);
     spacedline(log,' ');
     writeln(log,lines:8,' lines  of IO data. ',#13#10,
                 'Lcoeff= ',learn:8:2,
                 ' Momentum= ',momentum:8:2,
                 ' Kmod    = ',kmod:6:2,
                 ' Maxerr= ',maxerr:8:6,
                 ' Maxcount= ', maxcount:5);
     spacedline(log,' ');
     writeln(lines:8,' lines  of IO data. ',#13#10,
                 'Lcoeff= ',learn:8:2,
                 ' Momentum= ',momentum:8:2,
                 ' Kmod    = ',kmod:6:2,#13,#10,
                 ' Maxerr= ',maxerr:8:6,
                 ' Maxcount= ', maxcount:5);


     lines := countlines(data);
     readln(data);readln(data);
     linelength:= incount+outcount;

     new(desiredmat,init(lines,outcount));
     new(errorvec,init(outcount,1));
     new(inputmat,init(lines,linelength));


                                {Make Backpropnet -
                                 Really simple...}

     new(net,init(incount,hidecount,outcount,learn,momentum));
     net^.shake(0.8);
     net^.setfieldsignal(net^.hiddenfield,sigmoid);
     net^.setfieldsignal(net^.outputfield,linear);


     printmattofile(log,net^.weights^);
     printdynaerror;
     printneuralerror;

                              {Get input data}

     linestomat(data,inputmat^);
     writeln(log,'IO MATRIX');
     printmattofile(log,inputmat^);

     for i := 1 to lines do
         for j := 1 to outcount do
            desiredmat^.put(i,j,inputmat^.get(i,incount+j));
     writeln(log,'DESIRED MATRIX');
     printmattofile(log,desiredmat^);

     for i := 1 to outcount do inputmat^.deletecol(incount+i);
     writeln(log,'INPUT MATRIX');
     printmattofile(log,inputmat^);



                    {---------- present data -------------}

     count      := 0;

     repeat
       totalerror := 0;

       for j := 1 to lines do
          begin
          inc(count);
          desiredmat^.getrow(j,desiredvec);
          inputmat^.getrow(j,invec);
          net^.feedforward(invec);

                                {make error vector}

          for i := 1 to net^.outputfield^.count do
              begin
              thisone := net^.outputfield^.at(i-1);
              lasterror := (desiredvec^.get(i) - thisone^.output);
              totalerror := totalerror + abs(lasterror);
              errorvec^.put(i, lasterror);
              end;
                                { feed error back}

          net^.backpropall(errorvec);
          net^.getdeltaweights(net^.learn,net^.momen);
          end;

       if ((count mod (5*lines)) = 0) then
                 writeln(log,'Event # ',count,
                            totalerror:12:6);

       net^.adjustweights;

       gotoxy(1,10);
       write(count:10,totalerror:20:14,net^.learn:20:10,#13);
       for i:= 1 to errorvec^.count do
                    errorvec^.put(i,0.0);
       lasterror  := totalerror;
       totalerror := 0;



       if keypressed then
         begin
         key := readkey;

         if key = 'w' then
            begin
            new(io,init('net.stm',stcreate));
            io^.put(net);
            dispose(io,done);
            end;

         if key = 'r' then
            begin
            dispose(net,done);
            new(io,init('net.stm',stopen));
            net := psimplebpnet(io^.get);
            dispose(io,done);
            end;

         if key='s' then net^.shake(1.0);
         if key='S' then net^.shake(3.0);
         if key='l' then net^.learn := 0.7*net^.learn;
         if key='L' then net^.learn := 1.3*net^.learn;
         if key='q' then
           begin
           spacedline(log,'Network response: ');
           for j := 1 to lines do
            begin
            inputmat^.getrow(j,invec);
            net^.feedforward(invec);
            writeln(log);
            write(log,' inputvec  :');
            printvec(log,80,invec^);
            write(log,' response : ');
            for i := 1 to net^.outputfield^.count do
             write(log,pneuron(net^.outputfield^.at(i-1))^.output:8:3);
            end;
           writeln;
           close(log);
           halt(1);
           end;
         end;

       until (lasterror <maxerr) or (count > maxcount);





     spacedline(log,'Final Weights');
     printmattofile(log,net^.weights^);

     spacedline(log,'Network response: ');
     for j := 1 to lines do
          begin
          inputmat^.getrow(j,invec);
          net^.feedforward(invec);
          writeln(log);
          write(log,' inputvec  :');
          printvec(log,80,invec^);
          write(log,' response : ');
          for i := 1 to net^.outputfield^.count do
             write(log,pneuron(net^.outputfield^.at(i-1))^.output:8:3);
          end;
          writeln;

     close(data);
     close(log);

stop:

     writeln(memavail,' after initialized');
     writeln;
     writeln(max - memavail,' USED');

     dispose(net,done);
     dispose(errorvec,done);
     dispose(desiredmat,done);
     dispose(inputmat,done);

     writeln;
     writeln(memavail,' after cleanup ', (1.0*max-memavail):8:0,' lost');
     readln;
end.