
/****************************************************************************
*   Function:    int sockw(int fd, char *ptr)                               *
*   Operation:   to write character array to socket fd, assuring a newline  *
*   Returns:     a 0 for OK, or -1 for error (from sockwn())                *
*   Parameters:  fd, socket file descriptor                                 *
*                ptr, address of character array to write                   *
*   Calls:       sockwn()                                                   *
****************************************************************************/

#include <string.h>

int sockw(fd, ptr)
  register int fd;
  register char *ptr;
{
  int nbytes, tbytes;

  tbytes = strlen(ptr);
  for (nbytes = 0; nbytes <= tbytes; nbytes++) {
    if (ptr[nbytes] == '\n')	/* looking for a newline */
      ptr[nbytes] = 0;
    if (ptr[nbytes] == '\r')	/* looking for a return */
      ptr[nbytes] = 0;
    if (ptr[nbytes] == 0)	/* or a NULL */
      break;
  }
  strcat(ptr, "\n");	/* assuring the newline */
  nbytes = strlen(ptr);
  if (sockwn(fd, ptr, nbytes) == nbytes)
    return (0);
  else
    return (-1);
}
