/*
 *  sock.h --
 *      High level socket interface for PC NFS file server.
 *
 *  Author:
 *      See-Mong Tan
 */

#include <stdio.h>
#include <types.h>
#include <task.h>
#include <q.h>
#include <netq.h>
#include <net.h>
#include <custom.h>
#include <netbuf.h>
#include <icmp.h>
#include <ip.h>
#include <udp.h>
#include <tftp.h>
#include <timer.h>
#include <em.h>
#define       SOCK_STREAM     1               /* stream socket */
#define       SOCK_DGRAM      2               /* datagram socket */
#define  AF_INET         2               /* internetwork: UDP, TCP, etc. */
#define       IPPROTO_UDP             17          /* user datagram protocol */
#define       IPPROTO_TCP             6               /* tcp */



/* exported functions */

  /* creates socket - combination of 4 BSD "socket" and "bind" calls */
extern int sock_create(int, int, struct sockaddr_in *);
  /* closes socket - 4 BSD "close" */
extern void sock_close(int);
  /* receive - 4 BSD "recvfom" */
extern int sock_recv(int, char far *, int, struct sockaddr_in *);
  /* synchronous I/O multiplexing - 4 BSD "select" */
extern int sock_select(long *, long *);
  /* UDP message send */
extern int sock_send(int, struct sockaddr_in *, char far *, int);
  /* returns host name given internet address */
extern char *sock_gethostbyaddr(struct sockaddr_in);
  /* returns host address given host name */
extern long sock_gethostbyname(char *);
