/* original Copyright(C) 1992 Hiroya Tsubakimoto
 * modifications Copyright(C) 1993 Charles Sandmann
 * Merged with GO32 V1.09+ C. Sandmann sandmann@clio.rice.edu
 * Distributed under terms of "copying.dj" when distributed with GO32 source
 * Distributed under terms of GPL if used in any other code  */

typedef struct {
  struct {
    word8 major, minor;
  } version;
  word16 flags;
  word16 cpu;
  struct {
    word8 master, slave;
  } PIC;
} DPMIinfo;

typedef struct {
  word32 address;
  word32 bytes;
  word32 handle;
} DPMImemory;

typedef struct {
  word32 offset;
  word16 selector;
} DPMIaddress;

extern int exitDPMI;
extern char use_DPMI;

#if ! DEBUGGER
/* real mode function(s) */
int initDPMI(DPMIinfo* info);
void DPMIprotectedMode(void);
void DPMIexecute(void);

void Pmemget(word16 sel, word32 off, void* addr, word16 bytes);
void Pmemput(word16 sel, word32 off, const void* addr, word16 bytes);
void Pmemset(word16 sel, word32 off, word8 value, word32 bytes);
word16 Pmemscan(word16 sel, word32 off, word8 value, word16 bytes);

/* protected mode function(s) */
void uninitDPMI(int retcode);
void DPMIrealMode(void);
int DPMIalloc(DPMImemory* mem, word32 bytes);
int DPMIrealloc(DPMImemory* mem, word32 bytes);
void DPMIfree(DPMImemory* mem);
word16 DPMIselector(word16 number);
int DPMIassignSelector(word16 selector, word16 type, word32 base, word32 limit);
void DPMIchangeException(word8 no, DPMIaddress* handler);
void DPMIchangeInterrupt(word8 no, DPMIaddress* handler);
void DPMIhandler(word8 no, DPMIaddress* handler);

#define exit(n) ( exit(exitDPMI=(n)) )

#else
/* Dummy functions; DEBUGGER doesn't work under DPMI and is memory tight */
#define initDPMI(n) 0
#define DPMIprotectedMode()
#define DPMIexecute()
#define Pmemget(s,o,a,b)
#define Pmemput(s,o,a,b)
#define Pmemset(s,o,v,b)
#define Pmemscan(s,o,v,b) 1
#define uninitDPMI(n)
#define DPMIrealMode()
#define DPMIalloc(m,b) 1
#define DPMIrealloc(m,b) 1
#define DPMIfree(m)
#define DPMIselector(n) 1
#define DPMIassignSelector(s,t,b,l) 1
#define DPMIchangeException(n,h)
#define DPMIchangeInterrupt(n,h)
#define DPMIhandler(n,h)

#endif
