#include <stdio.h>
#include <stdlib.h>

typedef unsigned long word32;
#include "aout.h"

void badfile(void)
{
	fputs("File 'sym32.o' does not exist or invalid\n",stderr);
	exit(1);
}

void main(void)
{
	FILE *in = fopen("sym32.o","rb");
	FILE *out = fopen("sym32.h","wa");
	int  pos,inch,size;
	GNU_AOUT hdr;

	if(in == NULL) badfile();
	size = fread(&hdr,sizeof(hdr),1,in);
	if(size != 1) badfile();
	if(hdr.dsize || hdr.bsize || hdr.symsize || hdr.txrel || hdr.dtrel) badfile();
	size = (int)hdr.tsize;
	for(pos = 0; pos < size; pos++) {
	    inch = getc(in);
	    if(inch == EOF) badfile();
	    fprintf(out,"\t0x%02x,\n",(inch & 0xff));
	}
	fclose(in);
	fclose(out);
	exit(0);
}

