; -*-Emacs-Lisp-*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; File:         oemacs.el
; RCS:          $Header: f:/flat32/emacs-18.59/lisp/nonstd/RCS/oemacs.el 1.1 1993/04/17 10:59:20 darrylo Exp darrylo $
; Description:  oemacs-specfic version info code (stolen from demacs), and
;		other sundry phoo.
; Author:       Darryl Okahata
; Created:      Tue Mar 30 23:43:03 1993
; Modified:     Sat Aug 14 12:29:23 1993 (darrylo@home) darrylo@hostigos
; Language:     Emacs-Lisp
; Package:      N/A
;
; (C) Copyright 1993, Darryl Okahata, all rights reserved.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(defconst oemacs-version "4.00" "\
Version number of oemacs.")

(defconst oemacs-version-date "July 30, 1993" "\
Distribution date of this version of oemacs.")


(defun oemacs-version ()
  "\
Display oemacs version info"
  (interactive)
  (if (interactive-p)
      (message "%s" (demacs-version))
    (format "Oemacs version %s of %s"
	    oemacs-version oemacs-version-date)))


(defun oemacs-check-info-directory (dir)
  "Check to see if DIR is an Info directory containing a \"localdir\" file.
DIR is expanded relative to `exec-directory'.  If it is, add it to
`Info-directory-list'."
  (let ( (realdir (expand-file-name dir exec-directory))
	 file
	 )
    (setq file (expand-file-name "localdir" realdir))
    (if (file-exists-p file)
	(setq Info-directory-list (append Info-directory-list
					  (cons realdir nil))))
    ))


(defmacro oemacs-2format (n)
  (` (format "0x%04x%04x" (car (, n)) (car (cdr (, n))))))

(defun meminfo ()
  "Display various memory sadistics about OEmacs.
Works only if OEmacs was compiled with WATCOM C/386"
  (interactive)
  (let ( (buf "*meminfo*")
	 (info (emacs-debug-get-addresses))
	 (dpmi-info (emacs-dpmi-info))
	 )
    (pop-to-buffer buf)
    (buffer-disable-undo (current-buffer))
    (erase-buffer)
    (insert (format "Largest available block          = %s KB\n"
		    (nth 0 dpmi-info)))
    (insert (format "Maximum unlocked page allocation = %s pages\n"
		    (nth 1 dpmi-info)))
    (insert (format "Maximum locked page allocation   = %s pages\n"
		    (nth 2 dpmi-info)))
    (insert (format "Linear address space size        = %s pages\n"
		    (nth 3 dpmi-info)))
    (insert (format "Total unlocked pages             = %s pages\n"
		    (nth 4 dpmi-info)))
    (insert (format "Number of free pages             = %s pages\n"
		    (nth 5 dpmi-info)))
    (insert (format "Total number of physical pages   = %s pages\n"
		    (nth 6 dpmi-info)))
    (insert (format "Free linear address space        = %s pages\n"
		    (nth 7 dpmi-info)))
    (insert (format "Size of paging file/partition    = %s pages\n"
		    (nth 8 dpmi-info)))
    (insert (format "Data start = %s\n" (oemacs-2format (nth 0 info))))
    (insert (format "Data end   = %s\n" (oemacs-2format (nth 1 info))))
    (insert (format "BSS start  = %s\n" (oemacs-2format (nth 2 info))))
    (insert (format "BSS end    = %s\n" (oemacs-2format (nth 3 info))))
    ))

(defun auto-hscroll-hook ()
  "Automatically scroll the window horizontally if lines are truncated.
This function should be added to the post-command-hook."
  (if truncate-lines
      (hscroll-point-visible)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; On MS-DOS file system, we can't control version of backup file.
(setq version-control 'never)

;;
;; add binary file type
;;
(define-file-name-file-type "\\.arc" 1)
(define-file-name-file-type "\\.zip" 1)
(define-file-name-file-type "\\.lha" 1)
(define-file-name-file-type "\\.lzh" 1)
(define-file-name-file-type "\\.arj" 1)
(define-file-name-file-type "\\.dvi" 1)
(define-file-name-file-type "\\.z" 1)
(define-file-name-file-type "\\.gz" 1)		;; For GNU zip or compressed
						;; files.

;;
;; completion
;;
(setq completion-ignored-extensions
      (append completion-ignored-extensions
	      '(".obj" ".exe" ".bin" ".com" ".arc" ".zip" ".lha" ".lzh"
		".arj" ".dvi" ".z" ".gz")))

;;
;; For the new C++ mode (unfortunately, under MSDOS, the filename is called
;; "cxx-mode.el", instead of "c++-mode.el"; also "c++-mode-1.el" has been
;; renamed to "cxx-mod1.el").
;;
(autoload 'c++-mode   "cplus-md" "C++ Editing Mode" t)
(autoload 'c++-c-mode "cplusmd1" "C Editing Mode" t)
(setq auto-mode-alist
      (append '(("\\.C$"  . c++-mode)
		("\\.cc$" . c++-mode)
		("\\.cpp$" . c++-mode)
		("\\.hxx$" . c++-mode)
		) auto-mode-alist))

;;
;; Add hooks for perl-mode (unfortunately, this eliminates the use of
;; prolog-mode)
;;
(autoload 'perl-mode "perl-mode"
  "Major mode for editing Perl code.
Expression and list commands understand all Perl brackets.
Tab indents for Perl code.
Comments are delimited with # ... \\n.
Paragraphs are separated by blank lines only.
Delete converts tabs to spaces as it moves back.
\\{perl-mode-map}
Variables controlling indentation style:
 perl-tab-always-indent
    Non-nil means TAB in Perl mode should always indent the current line,
    regardless of where in the line point is when the TAB command is used.
 perl-tab-to-comment
    Non-nil means that for lines which don't need indenting, TAB will
    either delete an empty comment, indent an existing comment, move 
    to end-of-line, or if at end-of-line already, create a new comment.
 perl-nochange
    Lines starting with this regular expression will not be auto-indented.
 perl-indent-level
    Indentation of Perl statements within surrounding block.
    The surrounding block's indentation is the indentation
    of the line on which the open-brace appears.
 perl-continued-statement-offset
    Extra indentation given to a substatement, such as the
    then-clause of an if or body of a while.
 perl-continued-brace-offset
    Extra indentation given to a brace that starts a substatement.
    This is in addition to perl-continued-statement-offset.
 perl-brace-offset
    Extra indentation for line if it starts with an open brace.
 perl-brace-imaginary-offset
    An open brace following other text is treated as if it were
    this far to the right of the start of its line.
 perl-label-offset
    Extra indentation for line that is a label.

Various indentation styles:       K&R  BSD  BLK  GNU  LW
  perl-indent-level                5    8    0    2    4
  perl-continued-statement-offset  5    8    4    2    4
  perl-continued-brace-offset      0    0    0    0   -4
  perl-brace-offset               -5   -8    0    0    0
  perl-brace-imaginary-offset      0    0    4    0    0
  perl-label-offset               -5   -8   -2   -2   -2

Turning on Perl mode calls the value of the variable perl-mode-hook with no 
args, if that value is non-nil."
  t)
(setq auto-mode-alist (append (list (cons "\\.pl$" 'perl-mode))
			      auto-mode-alist))

;;*****************************************************************************
;;
;; Miscellaneous autoloads:
;;
;;*****************************************************************************

(autoload 'c-comment-edit "c-com-edit" "\
Edit multi-line C comments.
This command allows the easy editing of a multi-line C comment like this:
   /*
    * ...
    * ...
    */
The comment may be indented or flush with the left margin."
  t)

;;*****************************************************************************

(autoload 'set-c-style "c-style"
	  "Set up the c-mode style variables from STYLE if it is given, or
default-c-style otherwise.  It makes the c indentation style variables
buffer local."
	    t)

;;*****************************************************************************

(autoload 'see-chars "misc" "\
Displays characters typed, terminated by a 3-second timeout."
  t)

(autoload 'sum-column "misc" "\
Return the sum of the integers in the rectangle delimited
by START and END. Interactively, it prints the sum as well, and uses the
region."
  t)

(autoload 'sum-region "misc" "\
Adds up the numbers in the region START to END.  Primitive as yet.
If called interactively, uses the region and prints the sum in a message.
Ignores things that aren't numbers or signs, so 
  $1 + $4 
will sum to 5, and
  1 -4
will sum to -3.  Of course, it's really dumb, and things like
  2*3 - 5
will sum to 2+3+5 = 10 -- as will 2 + 3.5.  Improvements welcomed."
  t)

(autoload 'copy-region "misc" "\
Duplicate the region indicated by start and stop.  If repeat is non-nil,
it indicates how many copys to make.  The duplicates are inserted after
stop."
  t)

(autoload 'copy-line "misc" "\
Duplicate the current line.  If repeat is non-nil, it indicates how
many copys to make."
  t)

(autoload 'date-code "misc" "\
Update datecode and filecode of the current buffer.
This function is usually bound to write-file-hooks."
  t)

(autoload 'pass-to-sh "misc" "\
Pass the line that point is on to shell."
  t)

;;*****************************************************************************

(autoload 'edit-kbd-macro "macedit" "Edit a named keyboard macro" t)
(autoload 'edit-last-kbd-macro "macedit" "Edit a keyboard macro" t)
(autoload 'read-kbd-macro "macedit" "Parse region as keyboard macro" t)

;;*****************************************************************************

(autoload 'browse-kill-ring "b-k-ring" "\
Browses the kill ring in another buffer.
Use C-y to yank most recent kill ring entry (number 1.) into the buffer
which was current when browse-kill-ring was invoked.  Use a numeric argument
(M-# C-y) to yank the corresponding entry.

If you move point into the browse-kill-ring buffer, the keys C-y, y, Y, or SPC
will yank the entry on the current line into the previous buffer.

Note that browse-kill-ring should always be called before its contents is used;
its buffer is not automatically updated when kills and yanks are done.  This is
normally not a problem, since yanks will cause the buffer to be deleted
automatically."
  t)

;;*****************************************************************************

(autoload 'lispref-search "lispref"
	  "Symbol is regexps.  Search lispref manual, display text in other-window."
	  t)

;; C-c l is lispref-search
(global-set-key "\C-cl" 'lispref-search)
