/* DV/X support file.

   Author: Chris Boucher (ccb@soton.ac.uk).
   Copyright (C) 1993 Chris Boucher.

This file is part of GNU Emacs.

GNU Emacs is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU Emacs is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Emacs; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdio.h>
#include "config.h"

#ifdef DVX

#include <dos.h>


/*
 * Return DESQview version (0 if not in DESQview).
 */
static unsigned long
DESQview_version()
{
   union REGS regs;

   regs.h.ch = 'D';
   regs.h.cl = 'E';
   regs.h.dh = 'S';
   regs.h.dl = 'Q';
   regs.x.ax = 0x2b01;

   int86(0x21, &regs, &regs);

   return (regs.h.al == 0xff) ? 0 : regs.x.bx;
}


/*
 * Return DESQview/X version (0 if not in DESQview/X).
 */
static unsigned long
DESQviewX_version()
{
   union REGS regs;

   /* DESQview version must be 2.50 or greater. */
   if (DESQview_version() < 0x0232)
	   return 0;

   regs.x.ax = 0xDE30;

   int86(0x15, &regs, &regs);

   return regs.x.bx;
}


/*
 * Simple test for DESQview/X.
 */
in_DESQviewX()
{
	return (DESQviewX_version() > 0);
}
#endif /* DVX */
