{$N+,E+}
program TestCmpx;
{
                        To test the ShCmplx unit

                  Copyright 1991 Madison & Associates
                          All Rights Reserved

        This unit and the associated .DOC and TEST*.* files may
        be freely copied and distributed, provided only that no
        fee is charged for the package beyond a nominal copying
        charge, and provided that the package is distributed IN
        UNALTERED FORM. The sole exception to  this  latter re-
        striction is that bona-fide clubs and  user  groups may
        append text material to the documentation file, provid-
        ed that any material appended is clearly  identified as
        to its source, its beginning, and its end.
}

uses
  TpString,
  TpCrt,
  ShCmplx;

var
  A,
  B,
  C,
  D   : Complex;
  T1  : integer;
  Arad: ComplexElement;

begin
  New(A); New(B); New(C); New(D);
  A^.Re := 5.0; A^.Im := 12.0;
  WriteLn;
  WriteLn(Center('BASIC FUNCTION TEST',75));
  WriteLn;
  WriteLn
    ('The complex conjugate of ' + Cmp2Str(A,0,2) + ' is ' +
      Cmp2Str(CConjF(A),0,2));
  WriteLn
    ('The absolute value of ' + Cmp2Str(A,0,2) + ' is ' +
      Real2Str(CAbsF(A),0,4));
  B^.Re := 7.5; B^.Im := 6.25;
  WriteLn
    (Cmp2Str(A,0,2) + ' + ' + Cmp2Str(B,0,2) + ' = ' +
      Cmp2Str(CAddF(A, B),0,4));
  WriteLn
    (Cmp2Str(A,0,2) + ' - ' + Cmp2Str(B,0,2) + ' = ' +
      Cmp2Str(CSubF(A, B),0,4));
  WriteLn
    (Cmp2Str(A,0,2) + ' * ' + Cmp2Str(B,0,2) + ' = ' +
      Cmp2Str(CMulF(A, B),0,4));
  WriteLn
    (Cmp2Str(A,0,2) + ' / ' + Cmp2Str(B,0,2) + ' = ' +
      Cmp2Str(CDivF(A, B),0,4));
  C^.Re := 5.0; C^.Im :=  2.0;
  D^.Re := 3.0; D^.Im := -4.0;
  WriteLn
    (Cmp2Str(C,0,2) + ' / ' + Cmp2Str(D,0,2) + ' = ' +
      Cmp2Str(CDivF(C, D),0,4));
Write('Any key to continue...'); if ReadKey = '' then; WriteLn;
  WriteLn;

  WriteLn(Center('NESTED CALLS AND INVERSE FUNCTIONS TEST',75));
  WriteLn;
  WriteLn
    (Cmp2Str(A,0,2) + ' + ' + Cmp2Str(B,0,2) + ' + ' +
     Cmp2Str(C,0,2) + ' + ' + Cmp2Str(D,0,2) + ' = ');
  WriteLn
    ('':10, Cmp2Str(CAddF(A, CAddF(B, CAddF(C, D))),0,2));
  WriteLn
    (Cmp2Str(A,0,2) + ' / ' + Cmp2Str(B,0,2) + ' * ' + Cmp2Str(B,0,2) +
     ' = ' + Cmp2Str(CMulF(CDivF(A, B), B), 0, 2));
  WriteLn
    (Cmp2Str(A,0,2) + ' + ' + Cmp2Str(B,0,2) + ' - ' + Cmp2Str(B,0,2) +
     ' = ' + Cmp2Str(CAddF(CSubF(A, B), B), 0, 2));
Write('Any key to continue...'); if ReadKey = '' then; WriteLn;
  WriteLn;

  WriteLn(Center('COORDINATE SYSTEM TRANSFORMATION TEST',75));
  WriteLn;
  A^.Re := sqrt(3.0)*0.5; A^.Im := 0.5; {FIRST QUADRANT}
  C2P(A, B);
  WriteLn(Cmp2Str(A,0,2),' is ',CmpP2StrD(B,0,2));
  A^.Re := -sqrt(3.0)*0.5; A^.Im := 0.5; {SECOND QUADRANT}
  C2P(A, B);
  WriteLn(Cmp2Str(A,0,2),' is ',CmpP2StrD(B,0,2));
  A^.Re := -sqrt(3.0)*0.5; A^.Im := -0.5; {THIRD QUADRANT}
  C2P(A, B);
  WriteLn(Cmp2Str(A,0,2),' is ',CmpP2StrD(B,0,2));
  A^.Re := sqrt(3.0)*0.5; A^.Im := -0.5; {FOURTH QUADRANT}
  C2P(A, B);
  WriteLn(Cmp2Str(A,0,2),' is ',CmpP2StrD(B,0,2));
  WriteLn;

  A^.Re := 1.0;
  for T1 := 0 to 36 do begin
    A^.Im := 10.0 * T1 * Pi / 180.0;
    C := C2PF(P2CF(A));
    Write(CmpP2StrD(C,0,2));
    if (T1 mod 4) = 0 then
      WriteLn
    else
      GoToXY(20*(T1 mod 4), WhereY);
    end;
Write('Any key to continue...'); if ReadKey = '' then; WriteLn;
  WriteLn;

  WriteLn(Center('POWER TEST',75));
  WriteLn;
  A^.Re := 8.0; A^.Im := 0.0; Arad := 1.0/3.0;
  WriteLn(CmpP2StrD(A,0,4),' ^ ',Arad);
  WriteLn(CmpP2Str(A,0,4),' ^ ',Arad);
  for T1 := 0 to 3 do begin
    B^ := CpPwrRF(A, Arad)^;
    while B^.Im >= 2.0*Pi do B^.Im := B^.Im - 2.0*Pi;
    Write(CmpP2StrD(B,0,4));
    GoToXY(25, WhereY); Write(' is ', Cmp2Str(P2CF(B),0,4));
    GoToXY(50, WhereY); WriteLn('is ',CmpP2Str(B,0,4));
    A^.Im := A^.Im + 2.0*Pi;
    end;
  WriteLn;
  A^.Re := 125.0; A^.Im := 15.0*Pi/180.0;
  WriteLn(CmpP2StrD(A,0,4),' ^ ',Arad);
  WriteLn(CmpP2Str(A,0,4),' ^ ',Arad);
  for T1 := 0 to 3 do begin
    B^ := CpPwrRF(A, Arad)^;
    while B^.Im >= 2.0*Pi do B^.Im := B^.Im - 2.0*Pi;
    Write(CmpP2StrD(B,0,4));
    GoToXY(25, WhereY); Write('is ', Cmp2Str(P2CF(B),0,4));
    GoToXY(50, WhereY); WriteLn('is ',CmpP2Str(B,0,4));
    A^.Im := A^.Im + 2.0*Pi;
    end;
  end.
