program mdp5;

{Program to accompany article in issue #10 of the Pascal NewsLetter.        }
{Author: Mitch Davis, (3:634/384.6) +61-3-890-2062.                         }

{After reading the file specified on the command line, this program will   }
{instantly jump to any line (up to about 16000) you choose.  This shows a  }
{"random-access" way of accessing normally-sequential text files.  Note    }
{that it works by storing the file offset of the start of each line in an  }
{array.                                                                    }

{$M 16384,21000,21000} {leave room for the text buffer}

uses crt,Textutl2;

const MaxLines = 16000;
      TBuffSize = 20; {k}
      ScreenLen = 24;
      LineCount:word = 0;

type TBuffPtr  = ^TBuffType;
     TBuffType = array [1..TBuffSize*1024] of byte; {20k text buffer}

var LinePtr:array [1..MaxLines] of longint; { This takes nearly 64k }
    TBuff:TBuffPtr;
    Buffer:string;
    Loop,LNum:word;
    f:text;

  procedure PrLn (var s:string);

  begin
    writeln (copy (s,1,79));
  end;

begin
  writeln ('Reading...');
  {Set up text buffer}
  new (TBuff); {Get the memory for the buffer}
  assign (f,paramstr (1));
  SetTextBuf (f,TBuff^); {Tell the TP RTL about it.}
  reset (f);
  LineCount := 0;
  while not (eof (f) or (LineCount = MaxLines)) do begin
    inc (LineCount);
    write (LineCount,#13);
    LinePtr [LineCount] := TextFilePos (f);
    readln (f);
  end;
  writeln;

  clrscr;
  repeat
    if Linecount = 0 then begin
      writeln ('File is empty.');
      close (f);
      dispose (TBuff); {not really needed, but here for looks.}
      halt;
    end;
    write ('Enter a line number (1-',LineCount,', 0 to quit): ');
    readln (lnum);
    if (lnum > 0) and (lnum <= LineCount) then begin
      clrscr;
      TextSeek (f,LinePtr [lnum]);
      loop := 0;
      repeat
        readln (f,buffer);
        prLn (buffer);
        inc (loop);
      until (loop = ScreenLen) or eof (f);
      repeat until keypressed;
    end;
  until lnum = 0;
  close (f);
  dispose (TBuff);
end.
