/*********************************************************************
 * Example program to show how easy it is to use RESPLAY from within
 * any program.. consult your manual on how to do it inside BASIC,
 * PASCAL, C, (assembler is ever easier)
 *
 * This program is Public Domain. Do with it anything you want as
 * long as you keep my name in the header! (Send me a copy if its good!)
 *
 * Mark J Cox. December 1990.
 * 8/1/91: Fixed bug that caused FREAD to stop at a ^Z (Used "+rb" !)
 *
 * (Written in Turbo C - Must be compiled using LARGE model)
 *********************************************************************/

/* Allocates as much memory as possible, reads in a file and then
   plays it through the speaker.  Unfortunately, FREAD seems to stop
	 at 64k... I don't know enough about C to get around this, I'm sure
	 someone else will though!                                         */

#include <alloc.h>
#include <stdio.h>
#include <dos.h>

#define MAGIC       0x7746
#define CHECK_INST  0x8201
#define RESPLAY     0x2f
#define SETUP       0x8210
#define PLAYER      0x8200
#define SUCESS      0x1000
#define FAILED      0x2000
#define PLAY        0
#define SPEAKER     4
#define LPT2        1
#define SAMPLE      1

FILE *stream;
int do_it (int,int,int,unsigned int,unsigned int,unsigned int,unsigned int);

/*---------------------------------------------------------------*/

int do_it(  int mode, int device, int speed,
	unsigned int st_msb, unsigned int st_lsb,
	unsigned int len_msb, unsigned int len_lsb)
{
	 union REGS inregs,outregs;

	 inregs.x.ax = SETUP; 		  inregs.h.cl = mode;
	 inregs.h.bl = device;            inregs.h.bh = speed;
	 int86(RESPLAY,&inregs,&outregs);
	 if (outregs.x.ax==SUCESS)
	 {
		 inregs.x.dx = st_msb;      inregs.x.di = st_lsb;
		 inregs.x.cx = len_msb;     inregs.x.bx = len_lsb;
		 inregs.x.ax = PLAYER;
		 int86(RESPLAY,&inregs,&outregs);
	 }
	 return (outregs.x.ax == SUCESS);
}
/*---------------------------------------------------------------*/

main()
{
	union REGS inregs,outregs;
	unsigned int play_seg,play_off;
	unsigned int len_msb, len_lsb;
	long int size,to_alloc;
	char far *buffer;

	inregs.x.ax=CHECK_INST;
	int86(RESPLAY,&inregs,&outregs);
	if (outregs.x.ax != MAGIC)
	{
		 printf("Error: RESPLAY is not installed\n");
		 exit (1);
	}
	to_alloc = farcoreleft() - 40000;      /* Free Mem - 40k for C */
	if ((buffer=farmalloc(to_alloc))==NULL)
	{
		printf("Cant Allocate Memory\n");
		exit(0);
	}
	if ((stream=fopen("test.smp","rb+"))==NULL)
	{
		printf("Can't open file test.smp\n\n");
		exit(1);
	}
	size = fread(buffer,sizeof(char),65535,stream);
	printf("Example: Allocated %ldk bytes.  'test.smp' is %ldk bytes \n",
		(to_alloc/1024),(size/1024));

        play_off = FP_OFF(buffer);   /* Get pointer in xxxx:yyyy form */
	play_seg = FP_SEG(buffer);
	len_msb = (size/65536);
	len_lsb = size - len_msb*(size/65536);
	fclose(stream);

/* Play through Speaker, 16.0kHz from play_seg:play_off for len_msb,len_lsb */

	if (!do_it (PLAY,SPEAKER, 16*4, play_seg, play_off , len_msb, len_lsb))
	{
		printf("Error\n");
		exit(1);
	}
	farfree(buffer); /*Free alloced memory */
	exit(0);
}
/*---------------------------------------------------------------*/
