main	group	code
code	segment	public	para	'code'
assume	cs:main

org	100h				;.COM file

BEGIN:	jmp	START			;program starts here
		db	"Copyright 1986 Ziff-Davis Publishing Co.",1Ah
signature	db	'PUSHDIR VERSION 1.0'
lengthsignature = $ - signature

savedint16	dd	?		;used to be identical to pushdir

nextpush	dw	offset main:push1dir	;next place to save a dir
push1dir	db	67 dup (0)
push2dir	db	67 dup (0)
push3dir	db	67 dup (0)
push4dir	db	67 dup (0)
push5dir	db	67 dup (0)
push6dir	db	67 dup (0)

;up to here must be EXACTLY identical in both PUSHDIR and POPDIR.

notinstalled1	db	'Must run PUSHDIR.COM before POPDIR.COM'
		db	' will do anything.',13,10,10,'$'
errpop1		db	'Error popping the current directory',13,10,10,'$'

START:
	sti				;interrupts on

	;is PUSHDIR already installed ?

	mov	ax,7788h			;signature request
	mov	bx,7789h			;signature request
	mov	si,offset main:signature	;point ds:si to signature
	int	16h			;is it installed ?
	
assume	ds:nothing
	
	cmp	bx,7788h			;were ax and bx switched ?
	jne	NOTINSTALLED		;no
	cmp	ax,7789h			;were ax and bx switched ?
	jne	NOTINSTALLED		;no
	jmp	short ISINSTALLED		;yes - continue, no error
NOTINSTALLED:

	;here PUSHDIR was not previously installed so POPDIR can't do anything
	;useful so we just terminate with an error message.

	mov	dx,offset main:notinstalled1	;error message
	mov	ah,9
	int	21h
	int	20h			;exit


ISINSTALLED:

	;get the address of the directory previously saved by pushdir

	mov	bp,ds:[nextpush]		;get the next push location
	sub	bp,67				;back up one to the last push
	cmp	ds:[nextpush],offset main:push1dir	;need to wrap back ?
	jne	NOWRAPBACK			;no
	mov	bp,offset main:push6dir		;yes, wrap back
NOWRAPBACK:

	;set the current directory

	mov	dx,bp			;load ds:dx with directory to set
	mov	ah,3bh			;dos function number
	int	21h			;set current dir back
	jc	ERRPOP			;branch on error
	mov	ds:[nextpush],bp	;update [nextpush] if successful

	;set the current drive also	

	mov	dl,ds:[bp]			;get drive letter from path
	sub	dl,'A'				;convert to binary (0=A, 1=B)
	mov	ah,0eh				;dos function number
	int	21h				;set drive

	;exit successfully with no message

	int	20h 				;exit

ERRPOP:
	push	cs
	pop	ds				;set ds = cs
	mov	dx,offset main:errpop1		;error message
	mov	ah,9				;dos function number
	int	21h				;show the message
	int	20h				;terminate
	
code	ends
end	BEGIN				;start execution at BEGIN
