title    READONLY.COM -- VERSION 1.0
;
;       ***************************************************
;       A utility that changes the mode of a file to read-
;       only status so that it cannot be changed or erased
;       by ordinary means.
;       ***************************************************
;
code segment
;
org     100h                    ; this is a COM file
;
assume  cs:code,ds:code,es:code
;
        jmp     main            ;avoid the data area
;
;       ===================================================
;
;       Data area:
;
copyright       db      'Version 1.0 -- Copyright 1985 by Winn L. Rosch, Esq.'
                                ; credit where credit is due
nothing         db      1ah     ; this byte lets us type the COM file
                                ;     without disasters
;
;       Error messages:
;
error1          db      'Error.  Bad file specifications.$'
error2          db      'Error.  No such file.$'
error3          db      'Error.  Path not found.$'
error5          db      'Error.  Access denied.$'
message         db      'Function completed as specified.$'
;
;       ===================================================
;
main:
        push    cs              ; make sure that data segment is same
        pop     ds              ;     as code segment
        mov     bx,0081h        ; check to be sure a filename is given
        mov     dl,[bx]         ; move byte following filename into DL
        cmp     dl,0dh          ; check for carriage return
        jz      er1             ; if we find a carriage return, run error message
        mov     dx,0082h        ; ds-dx now points to filename, as required
                                ;     by the DOS function we'll be calling
        mov     bx,dx
;
;       ---------------------------------------------------
;       This routine loops through the characters on the
;       command line, looking for a carriage return, which
;       delimits the filename
;       ---------------------------------------------------
;
marker:
        mov     al,[bx]         ; move character position into AL
        cmp     al,0dh          ; check for carriage return
        jz      carriage_return ; carriage return indicates end of filename
        inc     bx              ; advance to next character
        jmp     marker          ; keep going until we find a carriage return
;
;       ---------------------------------------------------
;       This routine merely changes the carriage return on
;       the command line into the zero required by the
;       function call so that it recognizes the proper
;       filename
;       ---------------------------------------------------
;
carriage_return:
        xor     ah,ah           ; make a zero
        mov     [bx],ah         ; changes the space after the filename
                                ;      into a zero required by function
        mov     ah,43h          ;
        mov     al,00h          ; tells DOS to read attribute byte
        int     21h             ; make function call
        call    error_check     ; check for errors
        mov     ah,43h          ; DOS file attribute byte function call
        mov     al,01h          ; indicates that attribute byte to be changed
        or      cx,1            ; set attribute to read-only
;
                                ;=============================================
                                ; NOTE!!!  Changing this instruction to      ;
                                ; "and al,0fffeh" will convert this program  ;
                                ; to one which will REMOVE read-only         ;
                                ; status from a write-protected file.        ;
                                ;=============================================
;
        int     21h             ; make function call
                                ; if everything went okay, say so
        mov     dx,offset message
;
sign_off:
        mov     ah,09           ; load DOS print string function
        int     21h             ; call DOS
        int     20h             ; exit
;
;
;
er1:
        mov     dx,offset error1
        jmp     sign_off
er2:
        mov     dx,offset error2
        jmp     sign_off
er3:
        mov     dx,offset error3
        jmp     sign_off
er5:
        mov     dx,offset error5
        jmp     sign_off
;
;       ---------------------------------------------------
;       The following procedure checks the character returned
;       in the AX register for errors after making the function
;       call.  If an error is found, it loads the appropriate
;       message, then exits.
;       ---------------------------------------------------
;
error_check     proc    near
;
        cmp     ax,2
        jz      er2
        cmp     ax,3
        jz      er3
        cmp     ax,5
        jz      er5
        ret
;
error_check     endp
;
code            ends
                end main
