*
* COLOR.PRG  - Example use of COLORPAR.PRG
*
SET PROCEDURE TO COLOR
ClrVar=""
ScrBuff = SAVESCREEN(4,21,17,56)     && Save screen area
@  4,21 CLEAR TO 17,56               && Clear the area
@  4,21 TO 17,56                     && Box the area
DO COLORPAR WITH ClrVar, 5, 22       && Get color pair
RESTSCREEN(4,21,17,56,ScrBuff)       && Restore screen area
RETURN

*****************************************************************
* COLORPAR - Displays a grid from which you can choose a color pair *
* Usage:  DO COLORPAR WITH ClrVar, Irow, Icol
* Where:  ClrVar will hold the resulting color pair
*         Irow is the starting row position for display
*         Icol is the starting column position for display
*
* Example: DO COLORPAR WITH WinClr, 10, 20
*****************************************************************
PROCEDURE COLORPAR
PARAMETERS CLRVAR, IROW, ICOL
PRIVATE SAVECLR, SAVEBLK

SAVEBLK = SETBLINK()            && Clipper 5.0 specific
SAVECLR = SETCOLOR()            && Save current color
SETBLINK(.F.)                   && Clipper 5.0 specific

STORE CHR(07) TO COR

@ IROW, ICOL+2 SAY "Select Color:"

IROW = IROW + 1

DECLARE BACK[8]
BACK[1] = "W"
BACK[2] = "N"
BACK[3] = "B"
BACK[4] = "G"
BACK[5] = "BR"
BACK[6] = "BG"
BACK[7] = "GR"
BACK[8] = "R"

DECLARE FORE[32]
FORE[1] = "W+"
FORE[2] = "W"
FORE[3] = "W+*"
FORE[4] = "W*"
FORE[5] = "B+"
FORE[6] = "B"
FORE[7] = "B+*"
FORE[8] = "B*"
FORE[9] = "G+"
FORE[10]= "G"
FORE[11]= "G+*"
FORE[12]= "G*"
FORE[13]= "R+"
FORE[14]= "R"
FORE[15]= "R+*"
FORE[16]= "R*"
FORE[17]= "BR+"
FORE[18]= "BR"
FORE[19]= "BR+*"
FORE[20]= "BR*"
FORE[21]= "GR+"
FORE[22]= "GR"
FORE[23]= "GR+*"
FORE[24]= "GR*"
FORE[25]= "BG+"
FORE[26]= "BG"
FORE[27]= "BG+*"
FORE[28]= "BG*"
FORE[29]= "N+"
FORE[30]= "N"
FORE[31]= "N+*"
FORE[32]= "N*"

FOR B = 1 TO 8
   FOR F = 1 TO 32
      SETCOR=FORE[F]+"/"+BACK[B]
      SET COLOR TO &SETCOR
      @ IROW+B,ICOL+F SAY COR
   NEXT
NEXT

ROW=IROW+1
COL=ICOL+1
BACKCOR=1
FORECOR=1

SET CURSOR OFF

DO WHILE .T.
   CELLCOR=FORE[FORECOR]+"/"+BACK[BACKCOR]
   SET COLOR TO &CELLCOR

   @ ROW,COL SAY "X"
   @ IROW+8+2, ICOL+8 SAY "This is a sample."

   INKEY(0)

   @ ROW,COL SAY COR

   DO CASE

    CASE LASTKEY()=4                            &&RIGHT
      DO CASE
       CASE FORECOR=32 .AND. BACKCOR=8
         FORECOR=1
         BACKCOR=1
         ROW=ROW-7
         COL=COL-31
       CASE FORECOR=32 .AND. BACKCOR<8
         FORECOR=1
         BACKCOR=BACKCOR+1
         ROW=ROW+1
         COL=COL-31
       OTHERWISE
         COL=COL+1
         FORECOR=FORECOR+1
      ENDCASE

    CASE LASTKEY()=19                           &&LEFT
      DO CASE
       CASE FORECOR=1 .AND. BACKCOR=1
         FORECOR=32
         BACKCOR=8
         ROW=ROW+7
         COL=COL+31
       CASE FORECOR=1 .AND. BACKCOR>1
         FORECOR=32
         BACKCOR=BACKCOR-1
         ROW=ROW-1
         COL=COL+31
       OTHERWISE
         COL=COL-1
         FORECOR=FORECOR-1
      ENDCASE

    CASE LASTKEY()=5                            &&UP
      DO CASE
       CASE FORECOR=1 .AND. BACKCOR=1
         FORECOR=32
         BACKCOR=8
         ROW=ROW+7
         COL=COL+31
       CASE FORECOR>1 .AND. BACKCOR=1
         FORECOR=FORECOR-1
         BACKCOR=BACKCOR+7
         ROW=ROW+7
         COL=COL-1
       OTHERWISE
         ROW=ROW-1
         BACKCOR=BACKCOR-1
      ENDCASE

    CASE LASTKEY()=24                           &&DOWN
      DO CASE
       CASE FORECOR=32 .AND. BACKCOR=8
         FORECOR=1
         BACKCOR=1
         ROW=ROW-7
         COL=COL-31
       CASE FORECOR<32 .AND. BACKCOR=8
         FORECOR=FORECOR+1
         BACKCOR=BACKCOR-7
         ROW=ROW-7
         COL=COL+1
       OTHERWISE
         ROW=ROW+1
         BACKCOR=BACKCOR+1
      ENDCASE

    CASE LASTKEY()=13                           &&ENTER
      EXIT

    OTHERWISE
      LOOP
   ENDCASE

ENDDO
SET CURSOR ON
CLRVAR = FORE[FORECOR]+"/"+BACK[BACKCOR]
SET COLOR TO &SAVECLR                  && Restore original color
SETBLINK(SAVEBLK)                      && Clipper 5.0 specific
RETURN
