DAYSINMONTH PROCEDURE


.model medium, basic
 
.code
 
; This procedure determines the number of days in a given month 
;
; Receives: Arg1 month in question
;           Arg2 year
; Returns:  AX number of days in month
; Formula used to determine number of days in month:
;           if month > 7 and evenly divisible by 2 then days = 31 
;           if month <= 7 and not evenly divisible by 2 then days = 31 
;           if month > 7 and not evenly divisible by 2 the days = 30 
;           if month < 7 and evenly divisible by 2 then days = 30  

DaysInMonth Proc Arg1:Word, Arg2:Word

    mov  bx,arg1             ;month
    mov  ax,[bx]             ; in AX,
    mov  bx,arg2             ;year
    mov  cx,[bx]             ; in CX
    cmp  ax,2                ;Is the month Feb?
    jz   feb                 ;Yes, go test for leap year
    push ax
    shr  ax,1                ;No, divide AX by 2
    jc   not_div_by_2
 
div_by_2:
    pop  ax                  ;Get original month
    sub  ax,7                ;Compare month to 7
    js   days_equal_30       ;Month is < 7
 
days_equal_31:
    mov  ax,31
    jmp  done
 
days_equal_30:
    mov  ax,30
    jmp  done
 
not_div_by_2:
    pop  ax                  ;Get original month
    cmp  ax,7                ;Compare month to 7
    jbe  days_equal_31
    jmp  days_equal_30
 
feb:
    mov  ax,cx               ;Year in AX
    push ax                  ;Save year for future tests
    mov  bx,100              ;First test, is year evenly
    div  bx                  ; divisible by 100
    or   dx,dx
    jz   check400            ;Yes, check divisibility by 400
 
    pop  ax                  ;No, get year again in AX
    mov  bx,ax               ;Put year in BX for comparison
    mov  cl,2
    shr  ax,cl               ;Divide year by 4
    shl  ax,cl               ; then multiply by 4
    cmp  ax,bx               ;Did we get original year back?
    jz   isleapyear          ;Yes, we have a leap year
    jmp  notleapyear         ;No

check400:
 
    pop  ax                  ;Get year back in AX
    mov  bx,400
    div  bx                  ;Divide it by 400
    or   dx,dx               ;Did it divide evenly
    jz   isleapyear          ;Yes, we have a leap year

notleapyear:
    mov  ax,28               ;28 = no leap year
    jmp  done
 
isleapyear:
    mov  ax,29               ;29 = leap year
 
done:
    ret
 
DaysInMonth Endp
End
 



