/*---------------------------------------------------------
   RECORD3.C -- Multimedia Windows Waveform Audio Recorder
                (c) Charles Petzold, 1991
  ---------------------------------------------------------*/

#include <windows.h>
#include <mmsystem.h>
#include <stdio.h>
#include "record3.h"

BOOL FAR PASCAL DlgProc (HWND, WORD, WORD, LONG) ;

static char szAppName [] = "Record3" ;

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
     {
     FARPROC lpDlgProc ;

     lpDlgProc = MakeProcInstance (DlgProc, hInstance) ;
     DialogBox (hInstance, szAppName, NULL, lpDlgProc) ;
     FreeProcInstance (lpDlgProc) ;

     return 0 ;
     }

BOOL FAR PASCAL DlgProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
     {
     static BOOL bRecording, bPlaying, bPaused ;

     switch (message)
          {
          case WM_COMMAND:
               switch (wParam)
                    {
                    case ID_RECORD_BEG:
                                        // Delete Existing Waveform File

                         remove ("record3.wav") ;

                                        // Open Waveform Audio and Record

                         if (!mciExecute ("open record3.wav alias mysound"))
                              return TRUE ;

                         mciExecute ("record mysound") ;

                                        // Change Enabled Buttons

                         EnableWindow (GetDlgItem (hwnd, ID_RECORD_BEG), FALSE);
                         EnableWindow (GetDlgItem (hwnd, ID_RECORD_END), TRUE) ;
                         EnableWindow (GetDlgItem (hwnd, ID_PLAY_BEG),   FALSE);
                         EnableWindow (GetDlgItem (hwnd, ID_PLAY_PAUSE), FALSE);
                         EnableWindow (GetDlgItem (hwnd, ID_PLAY_END),   FALSE);
                         SetFocus (GetDlgItem (hwnd, ID_RECORD_END)) ;

                         bRecording = TRUE ;
                         return TRUE ;

                    case ID_RECORD_END:
                                        // Stop, Save, and Close Recording

                         mciExecute ("stop mysound") ;
                         mciExecute ("save mysound") ;
                         mciExecute ("close mysound") ;

                                        // Change Enabled Buttons

                         EnableWindow (GetDlgItem (hwnd, ID_RECORD_BEG), TRUE) ;
                         EnableWindow (GetDlgItem (hwnd, ID_RECORD_END), FALSE);
                         EnableWindow (GetDlgItem (hwnd, ID_PLAY_BEG),   TRUE) ;
                         EnableWindow (GetDlgItem (hwnd, ID_PLAY_PAUSE), FALSE);
                         EnableWindow (GetDlgItem (hwnd, ID_PLAY_END),   FALSE);
                         SetFocus (GetDlgItem (hwnd, ID_PLAY_BEG)) ;

                         bRecording = FALSE ;
                         return TRUE ;

                    case ID_PLAY_BEG:
                                        // Open Waveform Audio and Play

                         if (!mciExecute ("open record3.wav alias mysound"))
                              return TRUE ;

                         mciExecute ("play mysound") ;

                                        // Change Enabled Buttons

                         EnableWindow (GetDlgItem (hwnd, ID_RECORD_BEG), FALSE);
                         EnableWindow (GetDlgItem (hwnd, ID_RECORD_END), FALSE);
                         EnableWindow (GetDlgItem (hwnd, ID_PLAY_BEG),   FALSE);
                         EnableWindow (GetDlgItem (hwnd, ID_PLAY_PAUSE), TRUE) ;
                         EnableWindow (GetDlgItem (hwnd, ID_PLAY_END),   TRUE) ;
                         SetFocus (GetDlgItem (hwnd, ID_PLAY_END)) ;

                         bPlaying = TRUE ;
                         return TRUE ;

                    case ID_PLAY_PAUSE:
                         if (!bPaused)
                                        // Pause the Play
                              {
                              mciExecute ("pause mysound") ;
                              SetDlgItemText (hwnd, ID_PLAY_PAUSE, "Resume") ;
                              bPaused = TRUE ;
                              }
                         else
                                        // Begin Playing Again
                              {
                              mciExecute ("play mysound") ;
                              SetDlgItemText (hwnd, ID_PLAY_PAUSE, "Pause") ;
                              bPaused = FALSE ;
                              }

                         return TRUE ;

                    case ID_PLAY_END:
                                        // Stop and Close

                         mciExecute ("stop mysound") ;
                         mciExecute ("close mysound") ;

                                        // Change Enabled Buttons

                         EnableWindow (GetDlgItem (hwnd, ID_RECORD_BEG), TRUE) ;
                         EnableWindow (GetDlgItem (hwnd, ID_RECORD_END), FALSE);
                         EnableWindow (GetDlgItem (hwnd, ID_PLAY_BEG),   TRUE) ;
                         EnableWindow (GetDlgItem (hwnd, ID_PLAY_PAUSE), FALSE);
                         EnableWindow (GetDlgItem (hwnd, ID_PLAY_END),   FALSE);
                         SetFocus (GetDlgItem (hwnd, ID_PLAY_BEG)) ;

                         bPlaying = FALSE ;
                         bPaused  = FALSE ;
                         return TRUE ;
                    }
               break ;

          case WM_SYSCOMMAND:
               switch (wParam)
                    {
                    case SC_CLOSE:
                         if (bRecording)
                              SendMessage (hwnd, WM_COMMAND, ID_RECORD_END, 0L);

                         if (bPlaying)
                              SendMessage (hwnd, WM_COMMAND, ID_PLAY_END, 0L) ;

                         EndDialog (hwnd, 0) ;
                         return TRUE ;
                    }
               break ;
          }
     return FALSE ;
     }
