;MonoPrnt.ASM
;Copyright (c) 1992 Jay Munro
;First Published in PC Magazine June 16,1992

;Routine to access 2nd monochrome monitor from Visual Basic

;syntax:
;Call MonoPrint(Byval Text$, BYVAL Row%, BYVAL Col%, Byval Attr%)

.286
.Model Medium   
Public MonoPrint
Include Labnotes.Inc
Extrn __B000h:ABS               ;absolute selector
Extrn LStrLen:Proc              ;string length API routine

.Code
    Text$   Equ  [BP+12]        ;incoming parameters
    Row     Equ  [BP+10]
    Col     Equ  [BP+8]
    Attr    Equ  [BP+6]
    
MonoPrint Proc Far 
   WinProlog
   SaveESDISI
   Lds  SI,Text$                ;get segment/address to string
   Push DS                      ;push segment and address
   Push SI
   Call LStrLen                 ;get the length
   Mov  CX,AX                   ;get length into CX
   Jcxz Exit                    ;sorry, no zero len strings
   Mov  AX,__B000h              ;get exported selector
   Mov  ES,AX
   Mov  DI,Row                  ;get row
   Or   DI,DI                   ;skip dec if they used 0
   Jz   @F
   Dec  DI                      ;make 1 base to 0 base
@@:
   Mov  DX,Col                  ;and column
   Or   DX,DX                   ;    1 base to 0 base
   Jz   @F                      ;skip if they used 0
   Dec  DX                      ;
@@:
   Mov  BX,DI                   ;make a copy of rows
   Shl  DI,6                    ;multiply rows times 64
   Shl  BX,4                    ;multiply copy rows by 16
   Add  DI,BX                   ;add the two together to get 80
   Add  DI,DX                   ;and add columns in
   Shl  DI,1                    ;and double it for attribute
   Or   DI, DI                  ;if zero, the force row 3
   Jnz  @F
   Mov  DI,480
@@:
   Mov  AH,Byte Ptr Attr        ;attribute color
   Or   AH,AH
   Jnz  WriteLoop
   Mov  AH,7                    ;force a 7 attribute if zero comes in

WriteLoop:
   LodSb                        ;read a byte
   StoSw                        ;store a word
   Loop WriteLoop

Exit:
   RestESDISI
   WinEpilog
   Ret  10
MonoPrint EndP

End
