// modechk.c 

#include<windows.h>

int PASCAL WinMain(HANDLE, HANDLE, LPSTR, int);
long FAR PASCAL WndProc(HWND, unsigned int, WORD, long);

char *szWinDebug = "WinDebug";

int PASCAL WinMain(HANDLE hInstance,HANDLE hPrevInstance, LPSTR lpCmdLine,
    int nCmdShow)
    {
    HWND WndMain;       // window handle
    MSG msg;
   
    if(!GetSystemMetrics(SM_DEBUG))     // if not DEBUG mode
        return FALSE;                   // get outta Dodge

    if(!hPrevInstance)   /* If this is the first instance, register the class */
        {
        WNDCLASS wc;         /* Structure for registering window class */
        wc.style         = NULL;
        wc.lpfnWndProc   = WndProc;
        wc.cbClsExtra    = 0;
        wc.cbWndExtra    = 0;
        wc.hInstance     = hInstance;
        wc.hIcon = LoadIcon (hInstance, "ModeIcon");
        wc.hbrBackground = NULL; 
        wc.lpszClassName = szWinDebug;
        wc.hCursor       = LoadCursor(NULL,IDC_ARROW);
        wc.lpszMenuName  = NULL;
        if(!RegisterClass(&wc))
            return FALSE;
        }
    WndMain = CreateWindow(szWinDebug,szWinDebug,
        WS_CAPTION | WS_SYSMENU | WS_ICONIC,
        CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
        NULL,NULL, hInstance, NULL);

    if(!WndMain)
        return FALSE;

    ShowWindow(WndMain,SW_SHOWMINNOACTIVE);     // display as an icon
    UpdateWindow(WndMain);                      

    while(GetMessage(&msg,NULL,NULL,NULL))      // std message loop
        {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
        }
    return msg.wParam;
    }

long FAR PASCAL WndProc(HWND hWnd,unsigned int message,
    WORD wParam,long lParam)
    {
    switch (message) 
        {
        case WM_CREATE:         // when window is created,
            {                   // remove unneeded SysMenu items
            HMENU hSysMenu = GetSystemMenu(hWnd,0);
            RemoveMenu(hSysMenu, SC_RESTORE, MF_BYCOMMAND);
            RemoveMenu(hSysMenu, SC_MINIMIZE, MF_BYCOMMAND);
            RemoveMenu(hSysMenu, SC_MAXIMIZE, MF_BYCOMMAND);
            RemoveMenu(hSysMenu, SC_SIZE, MF_BYCOMMAND);
            }
            break;
        case WM_CLOSE:              
            DestroyWindow(hWnd); 
            break;
        case WM_DESTROY:           
            PostQuitMessage(0);
            break;
        default:
            return DefWindowProc(hWnd,message,wParam,lParam);
        }
    return 0L;
    }
