DEFINT A-Z

'$INCLUDE: 'QB.BI'

DECLARE FUNCTION FindFirst% (FileSpec$, Attribute%)
DECLARE FUNCTION FindNext% ()
DECLARE FUNCTION Trim$ (Work$)

TYPE DTAType
  Reserved  AS STRING * 21
  Attribute AS STRING * 1
  DateTime  AS LONG
  FileSize  AS LONG
  FileName  AS STRING * 13
END TYPE

DIM SHARED DTA AS DTAType
DIM SHARED Regs AS RegType

DirFlag = 0                     'set to -1 to get directories
Attribute = 7                   'match all file attributes
IF DirFlag THEN Attribute = 19

DO
   CLS
   LOCATE 2, 1, 1
   LINE INPUT "Enter a file specification: "; FSpec$
   PRINT
   NumFound = 0

   IF FindFirst%(FSpec$, Attribute) THEN
      DO
	IF DirFlag THEN               'for directories
	  IF ASC(DTA.Attribute) AND 16 THEN
	    PRINT Trim$(DTA.FileName)
	    NumFound = NumFound + 1
	  END IF
	ELSE                          'for regular files
	  PRINT Trim$(DTA.FileName); TAB(17);
	  PRINT USING "########"; DTA.FileSize
	  NumFound = NumFound + 1
	END IF
      LOOP WHILE FindNext%
   END IF

   PRINT : PRINT NumFound;
   IF DirFlag THEN
     PRINT "directories"
   ELSE
     PRINT "files"
   END IF

   PRINT
   PRINT "Find more files? (Y/N): ";
   YN$ = UCASE$(INPUT$(1))
   IF YN$ = "N" THEN END
LOOP

FUNCTION FindFirst% (FileSpec$, Attribute%)

  DIM FileSpecZ AS STRING * 80

  '---- Set up local disk transfer area
  Regs.ax = &H1A00                    'Set DTA function
  Regs.dx = VARPTR(DTA)
  CALL Interrupt(&H21, Regs, Regs)    'call DOS

  '---- Call the DOS Find First function
  FileSpecZ$ = FileSpec$ + CHR$(0)    'DOS uses ASCIIZ strings
  Regs.ax = &H4E00                    'DOS Find First function
  Regs.cx = Attribute%                'specify attributes
  Regs.dx = VARPTR(FileSpecZ$)        'DX points to FileSpecZ$
  CALL Interrupt(&H21, Regs, Regs)    'call DOS

  FindFirst% = (Regs.flags AND 1) = 0 'True if found

END FUNCTION

FUNCTION FindNext%

  Regs.ax = &H4F00                    'DOS Find Next function
  CALL Interrupt(&H21, Regs, Regs)    'call DOS
  FindNext% = (Regs.flags AND 1) = 0  'True if found

END FUNCTION

FUNCTION Trim$ (Work$)

  Null = INSTR(Work$, CHR$(0))          'find the zero byte
  Trim$ = LEFT$(Work$, Null - 1)        'return all to the left

END FUNCTION

