//
//  About box demo program for C++ OWL
//
//  Copyright 1993 by Danny Thorpe
//

#include <owl.h>
#include "about.h"

#define  CM_ABOUT  101
#define  IDBITMAP 200

const int test[10] = {1,2,3,4,5,6,7,8,9,0};
                   
LPSTR CreditText[8] = {
    "",
    "This is where you would",
    "put your own list of",
    "names or secret message",
    "to reward the users who",
    "discover this.",
    "",
    NULL};

class TDemoMainWindow : public TMDIFrame
{
public:
  TDemoMainWindow(LPSTR ATitle, LPSTR MenuName)
      : TMDIFrame(ATitle, MenuName) {};
  virtual void CMAbout(RTMessage) = [CM_FIRST + CM_ABOUT];
};

void TDemoMainWindow::CMAbout(RTMessage)
{
  GetApplication()->ExecDialog(
        new TAboutBox(this, "Demo About Box",
                  MAKEINTRESOURCE(IDBITMAP), CreditText));
};

/* TAboutDemoApp ------------------------------------------------------ */

class TAboutDemoApp : public TApplication
{
public:
        TAboutDemoApp(LPSTR name,
                      HINSTANCE hInstance,
                      HINSTANCE hPrevInstance,
                      LPSTR lpCmd, int nCmdShow)  
             : TApplication(name, hInstance, hPrevInstance,
                            lpCmd, nCmdShow) {};
        virtual void InitMainWindow();
};

void TAboutDemoApp::InitMainWindow()
{
  /* Create a main window of type TDemoMainWindow. */
  MainWindow = new TDemoMainWindow("Demo App","MainMenu");
};

// Run the AboutDemoApp
int PASCAL WinMain(HINSTANCE hInstance,
                   HINSTANCE hPrevInstance,
		   LPSTR lpCmd, int nCmdShow)
{
    TAboutDemoApp AboutDemoApp("AboutDemoApp",
                               hInstance, hPrevInstance,
		               lpCmd, nCmdShow);
    AboutDemoApp.Run();
    return AboutDemoApp.Status;
}
