/*/////////////////////////////////////////////////////////////////////////
//  External variable declarations to make them global and ally
//  resolved.
//
/////////////////////////////////////////////////////////////////////////*/

#include "animator.h"

HINSTANCE        _hInst;
HWND             _hwndFrame, _hwndClient, _hwndStatus;
HMENU            _hmenuMain, _hmenuMainWindow, _hmenuChild, 
						_hmenuChildWindow;
LONG             _lPageFlags;
LONG             _lPageFlags;
char             _szAppName[32];
char             _szChildClass[32];
char             _szTitleBar[32];
char             _szStatBarClass[32];
char             _szUntitled[32];
char             _szExtension[5];
char             _szTimeInt[32];
char             _szInfo[32];
char             _szNumIcons[32];
char             _szLinkFile[32];
char             _szIconSection[32];
char             _szIcon[32];
char             _szAutoAnimateKey[32];

FARPROC          _lpfnTimer;
FARPROC          _lpfnNotify;
FARPROC          _lpfnAbout;
FARPROC          _lpfnBroadcast;
FARPROC          _lpfnSettings;
HWND             _hTargethWnd;
int              _nTimerInterval;
int              _nStatBarDY;
ANIMSTRUCT       _animStruct[MAXANIMATIONS];
HPEN             _hpnGray;
HPEN             _hpnBlack;
HPEN             _hpnWhite;


// Common Dialogs stuff us_d in ShowOpenDialog() 

LPSTR           _lpszIconFilter[3] = {
						".ICO files (*.ico)",
						"*.ico",
						""};
LPSTR           _lpszScriptFilter[5] = {
						".ANM files (*.ANM)",
						"*.anm",
						"All files (*.*)",
						"*.*",
						""};
LPSTR           _lpszEXEFilter[5] = {
						".EXE files (*.EXE)",
						"*.exe",
						".COM files (*.COM)",
						"*.com",
						""};
#ifdef __cplusplus
"C" {
#endif 

// MAIN.C 
 VOID WINAPI              CenterWindow (HWND);      
 BOOL WINAPI              RestorePosition (HWND,short);
 VOID WINAPI              RecordPosition (HWND);
 short WINAPI             IntFromString (LPSTR FAR *);
 HWND WINAPI              GetWindowListbox (VOID);
 short WINAPI             GetWindowNumber(VOID);
 BOOL WINAPI              DeleteCurSel (HWND);
 VOID WINAPI              DeletePreviousHandles (HWND);
 VOID WINAPI              SetupIconHandles (HWND);
 BOOL WINAPI              CheckForDoubles (HWND);
 VOID WINAPI              MESSAGE (WORD);
 UINT WINAPI              GetTextWidth (HDC,LPSTR);
 UINT WINAPI              GetTextHeight (HDC,LPSTR);
 UINT WINAPI              GetANSITextHeight (VOID);
 HWND WINAPI              GetAppTaskWindow (char *);
 BOOL _export CALLBACK    NotifyProc (WORD,DWORD);

// FRAME.C 
 LRESULT _export CALLBACK FrameProc (WNDPROC_PARAMS);
 BOOL _export CALLBACK    BroadcastProc (HWND,LONG);
 VOID WINAPI              RefreshAnimations (VOID);

// CHILD.C 
 LRESULT _export CALLBACK ChildProc (WNDPROC_PARAMS);

// STATBAR.C 
 LRESULT _export CALLBACK StatusBarProc (WNDPROC_PARAMS);

// ABOUT.C
 BOOL _export CALLBACK    About (DLGPROC_PARAMS);

// TIMER.C
 VOID _export CALLBACK    TimerCallback (HWND,UINT,UINT,DWORD);
 VOID WINAPI              InvalidateAll (HWND, HICON);

// SETTINGS.C
 BOOL _export CALLBACK    SettingsDlg (DLGPROC_PARAMS);

// SHOWTASK.C 
 HANDLE _export CALLBACK  ShowTaskDlg(DLGPROC_PARAMS);
 BOOL _export CALLBACK    EnumCallback (HWND, LONG);

// FILEIO.C 
 BOOL WINAPI              ShowCommonDialog (HWND, LPSTR *, LPSTR, LPSTR, LPSTR, BOOL);VOID WINAPI              SaveIconsToFile (HWND, WORD);
 BOOL WINAPI              OpenIconsInFile (char *);
 BOOL WINAPI              LinkToExecutable (LPSTR);
 BOOL WINAPI              GetPathIfNoPath (LPSTR);

#ifdef __cplusplus
}
#endif
