#include "animator.h"

static char szTitle [MAX_FILE_SIZE];

//////////////////////////////////////////////////////////////////////////
// ShowTaskDlg - Dialog box procedure for the Set Window Task menu command
// by enumerating all of the windows on the display, and adding their
// titles to a listbox.  Uses FindWindow on the title to get the 
// window handle and returns it to the calling DialogBox function.
//////////////////////////////////////////////////////////////////////////

HANDLE _export CALLBACK ShowTaskDlg(DLGPROC_PARAMS)
{
	HWND    hwndList = GetDlgItem (hDlg, IDD_LISTBOX);
	FARPROC lpfn;
	HANDLE  hwnd;

	switch (uMsg) 
	{
		case WM_INITDIALOG:
		{
			CenterWindow (hDlg);

			lpfn = MakeProcInstance ((FARPROC)EnumCallback, _hInst);

			if (!EnumWindows (lpfn, MAKELONG (hwndList, 0)))
			{
				MESSAGE (IDS_TaskListErr);
				EndDialog (hDlg, NULL);
				break ;
			}

			FreeProcInstance (lpfn);
			return (TRUE);
		}

		case WM_COMMAND:
		{
			switch (wParam)
			{
				case IDD_LISTBOX:
				{
					if (HIWORD(lParam)==LBN_DBLCLK)
					{
						PostMessage (hDlg,WM_COMMAND,IDOK,0L);
					}
					break ;
				}
				case IDOK:
				{
					ListBox_GetText (hwndList, ListBox_GetCurSel(hwndList),
						(LPSTR)szTitle);

					hwnd = FindWindow (NULL, (LPSTR)szTitle);

					EndDialog (hDlg, hwnd);

					break ;
				}
				case IDCANCEL:
				{
					EndDialog (hDlg, NULL);
					break ;
				}
				default:
					break ;
			}
			return TRUE;
		}
	}

	return (FALSE);
}

//////////////////////////////////////////////////////////////////////////
// EnumCallback - This is the function used by ShowTaskDlg that adds the 
// task window titles to the listbox.  The global all-purpose variable
// szTitle is used to fetch the task titles.  If the task is 
// visible and has a title, then add it to the list.
//////////////////////////////////////////////////////////////////////////

BOOL _export CALLBACK EnumCallback (HWND hWnd, LONG lParam)
{
	if (GetParent (hWnd) == NULL)
	{
		GetWindowText (hWnd, (LPSTR)szTitle, MAX_FILE_SIZE);
		if (lstrlen (szTitle) && IsWindowVisible(hWnd))
		{
			if (LB_ERR == ListBox_AddString (LOWORD(lParam), (LPSTR)szTitle))
			{
				return FALSE;
			}
		}
	}
	return TRUE;
}
