                         {FLPT5}
{-------------doesc}
procedure doesc(pk : packet);        {do the esc instr}
begin
If Wait_Found then
  begin  insrtst(instrnames[opcodes[$9b]]); OutUstring; end;
usindex:=firsttab;
insrtst('ESC'); usindex:=secondtab;
insrthx2((opcode and 7)*8+reg);
comma; domem(pk);
end;

{-------------st_i}
procedure st_i;         {do st(i) }
begin
insrtst('ST(');
insrtchr(chr(rm+$30));
insrtchr(')');
end;

{-------------sti_st}
procedure sti_st;       {do st(i),st }
begin
st_i;
insrtst(',ST');
end;

{-------------db}
procedure db;
Const DB_NAME :array[0..11] of string[6] =
           ('FILD','','FIST','FISTP','','FLD','',
            'FSTP','FENI','FDISI','FCLEX','FINIT');
var     i       :word;
        pk : Packet;
        tmp : string[7];
begin
readmodebyte(pk); wd:=false;
if (mode=3) then i:=rm+8 else i:=reg;   {form an index}
tmp:=db_name[i];
if (tmp[0]>#0) and (i<=11) then
   begin
   if not Wait_Found then
     if i>=8 then  {'FENI','FDISI','FCLEX','FINIT' to no wait equivalents}
       Insert('N',tmp,2);
   insrtst(tmp); usindex:=secondtab;
   if i<=3 then
      begin
      insrtst('DWORD '); domem(pk);
      end
   else if i<=7 then
      begin insrtst('TBYTE '); domem(pk); end;
   end
else doesc(pk);
end;

{-------------dd}
procedure dd;
Const DD_NAME :array[0..11] of string[6] =
             ('FLD','','FST','FSTP','FRSTOR',
              '','FSAVE','FSTSW','FFREE','FXCH',
              'FST','FSTP');
var     i       :word;
        pk : Packet;
        tmp : string[7];
begin
readmodebyte(pk); wd:=false;
if mode=3 then i:=reg+8 else i:=reg;
tmp:=dd_name[I];
if (tmp[0]>#0) and (i<=11) then
   begin
   if not Wait_Found then
     if (i=6) or (i=7) then  {'FSAVE','FSTSW' to no wait equivalents}
       Insert('N',tmp,2);
   insrtst(tmp); usindex:=secondtab;
   if i<=3 then insrtst('QWORD ');
   if i<=7 then domem(pk)
   else st_i;
   end
else doesc(pk);
end;

{-------------df}
procedure df;
Const DF_NAME :array[0..11] of string[5] =
              ('FILD','','FIST','FISTP','FBLD',
               'FILD','FBSTP','FISTP','FFREE','FXCH',
               'FST','FSTP');
var     i       :word;
        pk : Packet;
begin
readmodebyte(pk); wd:=false;
if mode=3 then i:=reg+8 else i:=reg;    {form index}
if (i<>1) and (i<=11) then
   begin
   insrtst(df_name[I]); usindex:=secondtab;
   if i<=3 then
      begin insrtst('WORD '); domem(pk); end
   else if i<=7 then
      begin
      if (i and 5)=4 then insrtst('TBYTE ') else insrtst('QWORD ');
      domem(pk);
      end
   else st_i;
   end
else doesc(pk);
end;

{-------------d9}
procedure d9;
Const D9_NAME :array[0..11] of string[6] =
        ('FLD', '', 'FST', 'FSTP',
         'FLDENV', 'FLDCW', 'FSTENV', 'FSTCW',
         'FLD', 'FXCH', 'FNOP', 'FSTP');

Const D9_3_NAME :array[0..29] of string[7] =
       ('FCHS','FABS','','','FTST',
        'FXAM','','','FLD1','FLDL2T',
        'FLDL2E','FLDPI','FLDLG2','FLDLN2','FLDZ',
        '','F2XM1','FYL2X','FPTAN','FPATAN',
        'FXTRACT','','FDECSTP','FINCSTP','FPREM',
        'FYL2XP1','FSQRT','','FRNDINT','FSCALE');
var     i       :word;
        pk : Packet;
        tmp : string[7];
begin
readmodebyte(pk);
wd:=false;
if (mode<>3) or (reg<=3) then
   begin
   if mode=3 then i:=reg+8 else i:=reg;
   if (i=1) or ((i=10) and (rm<>0)) then doesc(pk)
   else
      begin
      tmp:=d9_name[I];
      if not Wait_Found then
        if (i=6) or (i=7) then  {'FSTENV', 'FSTCW' to no wait equivalents}
          Insert('N',tmp,2);
      insrtst(tmp);  usindex:=secondtab;
      if i<=3 then insrtst('DWORD ');
      if i<=7 then domem(pk)
      else if i<>10 then        {fnop is 10}
         st_i;  {st(i)}
      end;
   end
else
   begin        {mode=3 and reg>=4}
   i:=rm+(reg and 3)*8; {include lower 2 bits of reg in index}
   if (d9_3_name[I][0]>#0) and (I<=29) then
      insrtst(d9_3_name[I])
   else doesc(pk);
   end;
end;

{-------------d8_dc}
procedure d8_dc;
type    nametype=array[0..7] of array[1..5] of char;
var     shortreal       :boolean;
        pk : Packet;
const   d8_dc_name : nametype =(
          'FADD ','FMUL ','FCOM ','FCOMP','FSUB ','FSUBR','FDIV ','FDIVR');
begin
wd:=false;
shortreal:=opcode=$d8;
readmodebyte(pk);
if not shortreal then if (reg>=6) then {fdiv, fdivr are reversed here}
   reg:=reg xor 1;
insrtst(d8_dc_name[reg]);
usindex:=secondtab;
if mode<>3 then
   begin
   if shortreal then insrtst('DWORD ') else insrtst('QWORD ');
   domem(pk);
   end
else  {mode=3}
   if shortreal then
      begin insrtst('ST,'); st_i; end
   else sti_st;                 {add the stack info}
end;

{-------------da_de}
procedure da_de;
type    nametype=array[0..15] of array[1..6] of char;
var     shortint        :boolean;
        pk : Packet;
const   da_de_name : nametype = (
        'FIADD ','FIMUL ','FICOM ','FICOMP','FISUB ','FISUBR','FIDIV ',
        'FIDIVR','FADDP ','FMULP ','FCOMP ','FCOMPP','FSUBRP','FSUBP ',
        'FDIVRP','FDIVP ');
begin
wd:=false;
shortint:=opcode=$da;
readmodebyte(pk);
if mode<>3 then
   begin
   insrtst(da_de_name[reg]);
   usindex:=secondtab;
   if shortint then insrtst('DWORD ') else insrtst('WORD ');
   domem(pk);
   end
else
   begin        {mode=3}
   if shortint or ((reg=3) and (rm<>1)) then doesc(pk)      {not fl pt}
   else
      begin
      insrtst(da_de_name[reg+8]);
      usindex:=secondtab;
      if (reg<>3) then sti_st;
      end;
   end;
end;
