



;-----------------------------------------------------------------------
;  EGAINFO is a subroutine designed to be used with compiled or
;  interpreted BASIC. See the sample programs MAINPROG.BAS and
;  SUBPROG1.BAS which show you how the routine is implemented in
;   your programs.
;
;  This routine can be used as is for IBM and Microsoft BASIC, whether
;  compiled or interpreted.
;
;  For compiled IBM/MS BASIC, all you have to do
;  is assemble this code to create EGAINFO.OBJ and then LINK the module
;  with your program (or include in a user library). Assemble it like this:
;     MASM EGAINFO;
;
;  Then compile and LINK as shown below. If you are using QuickBASIC 1.0 or
;  either version of IBM's compiler, substitute BASCOM for QB.
;     QB Yourprog;
;     LINK Yourprog+EGAINFO;
;
;  If you are using Borland's Turbo Basic, you'll need to perform
;  the following steps:
;
;    1. Use the following commands to create a BIN file:
;         MASM EGAINFO;
;         LINK EGAINFO;
;         EXE2BIN EGAINFO EGAINFO.BIN
;         DEL EGAINFO.EXE
;    2. In your program, have a line that says:
;         $include "egainfo.bin"
;    3. change the following equate to 1:

TURBO_BASIC EQU 0

;  Note that it is very important that you use only integer variables when
;  calling the routine, since other types of variables can cause problems.
;
;  The syntax for calling this routine is:
;
;      CALL EGAINFO(EGAMODE%,EGACOLUMNS%,EGAROWS%,EGASTATUS%,EGAMEM%)
;
;  After calling the routine, check the variable EGASTATUS%. If it
;  is -1, there is no EGA in the system. If not -1, the variables
;  contain the following information:
;
;    EGAMODE% is the current video mode.
;    EGACOLUMNS% is the number of columns on the screen, if in text mode.
;    EGAROWS% is the number of rows on the screen, if in text mode.
;    EGASTATUS% is 0 if in color mode, 1 if in monochrome mode or
;             -1 if no EGA is present.
;    For VGA monitors, 10 is added to 0 or 1. In other words, if
;             10, VGA in color mode. If 11, VGA in mono mode.
;    EGAMEM% is the amount of memory on the EGA card in kilobytes.	    
;=======================================================================

CODE	SEGMENT PARA PUBLIC 'CODE'

	ASSUME CS:CODE,DS:NOTHING,SS:NOTHING,ES:NOTHING
;-----------------------------------------------------------------------
;  Equates - substituted literally when assembled
;-----------------------------------------------------------------------
IF TURBO_BASIC					; these are addresses
		EGAMODE 	EQU 22		; relative to the BP
		EGACOLUMNS	EQU 18		; register.
		EGAROWS		EQU 14
		EGASTATUS	EQU 10
		EGAMEM		EQU 06
ELSE		
		EGAMODE 	EQU 14
		EGACOLUMNS	EQU 12
		EGAROWS		EQU 10
		EGASTATUS	EQU 08
		EGAMEM		EQU 06
ENDIF

PUBLIC	EGAINFO
EGAINFO PROC FAR

		PUSH	BP			; save this register	
		MOV	BP,SP			; for addressing variables

		PUSH	SI			; necessary for QB 4
		PUSH	DI			; necessary for QB 4
		PUSH	ES			; BIOS changes this
		
		MOV	SI,[BP+EGASTATUS]	; point to EGASTATUS%
		MOV	WORD PTR [SI],-1	; Assume no EGA/VGA

		MOV	DX,0			; Assume no VGA
		MOV	AX,1A00H		; Check for VGA
		INT	10H			; Call the BIOS

		CMP	AL,1AH			; If still 1AH, no VGA
		JNZ	FIND_EGA		; No VGA, but maybe EGA
		CMP 	BL,7			; Make sure it's a VGA
		JE	FOUND_VGA		; If BL=7 or 8, it's a VGA
		CMP	BL,8
		JNE	FIND_EGA 		; if not, try to find EGA
FOUND_VGA:
		MOV	DX,10			; VGA is present
FIND_EGA:
		MOV	AH,12H			; service 12h
		MOV	BL,10H			; get EGA Information
		PUSH	BP			; some BIOS'es destroy this
		INT	10H			; call the BIOS routine
		POP 	BP			; retrieve BP pointer
		
		CMP 	BL,10H			; did it change?
		JZ	EGA_EXIT		; No, leave with -1 status
EGA_FOUND:
		MOV	AL,BH			; save color/mono setting
		XOR	AH,AH			; clear high bits of status
		ADD	AX,DX			; Add VGA status
		MOV	SI,[BP+EGASTATUS]	; point to variable
		MOV	WORD PTR [SI],AX	; pass to BASIC
		
		XOR	BH,BH			; clear high bits
		INC	BX			; now 1=64K, 2=128K, etc.
		MOV 	CX,6			; multiply by 64
		SHL	BX,CL			; shift bits to the left.
		MOV	SI,[BP+EGAMEM]		; point to variable
		MOV	WORD PTR [SI],BX	; pass to BASIC

		MOV	AX,1130H		; "Get pointer" service
		PUSH	BP			; this service changes BP
		INT	10H			; returns number of rows
		POP	BP			; restore register
		INC	DL			; returns number rel. to 0
		XOR	DH,DH			; clear high bits
		MOV	SI,[BP+EGAROWS]		; point to variable
		MOV	WORD PTR [SI],DX	; pass to BASIC

		PUSH	BP			; save in case destroyed
		MOV	AH,0FH			; get video mode
		INT	10H			; call the BIOS
		POP	BP			; retrieve register
		
		MOV	BL,AH			; number of columns
		XOR	BH,BH			; clear high bits
		MOV	SI,[BP+EGACOLUMNS]	; point to variable
		MOV	WORD PTR [SI],BX	; pass to BASIC
		
		XOR	AH,AH			; clear high bits of mode
		MOV	SI,[BP+EGAMODE]		; point to variable
		MOV	WORD PTR [SI],AX	; pass to BASIC
EGA_EXIT:
		POP	ES
		POP	DI			; for QB 4
		POP	SI			; for QB 4
		POP	BP			; restore for BASIC
IF NOT TURBO_BASIC
		RET	10			; clean up stack and return
ENDIF
		
EGAINFO ENDP
CODE	ENDS
END

