  FUNCTION Is_Extended : Boolean;
  TYPE
    Registers = RECORD
                  CASE Integer OF
                    1 : (AX, BX, CX, DX, BP, SI, DI, DS, ES, Flags : Integer);
                    2 : (AL, AH, BL, BH, CL, CH, DL, DH : Byte);
                END;
  VAR
    R : registers;
    Shift_State : Byte ABSOLUTE $40 : $17;
  BEGIN
    (*READ the current shift states using EXTENDED BIOS function*)
    R.AH := $12;
    Intr($16, R);
    (*IF the result is the same as the shift state byte, *)
    (*it's _probably_ an extended BIOS.     To be sure...*)
    IF R.AL <> Shift_State THEN Is_Extended := False
    ELSE
      BEGIN
        (*... we toggle the INSERT bit in the flag...*)
        Shift_State := Shift_State XOR $80;
        R.AH := $12;
        Intr($16, R);
        (*...and read the shift state again.*)
        Is_Extended := R.AL = Shift_State;
        Shift_State := Shift_State XOR $80;
      END;
  END;