;*--------------------------------------------------------------------*
;*   INFO.COM -- A DIFFERENT PAUSE FOR BATCH JOBS -- by Hal Shearer   *
;*--------------------------------------------------------------------*
;*              FORMAT:    INFO [40 CHARACTER MESSAGE]                *
;*--------------------------------------------------------------------*
CSEG	SEGMENT
	ASSUME	CS:CSEG,DS:CSEG
	ORG	100H
START:	JMP	INIT
STORE	DB	?
MSG	DB	40 DUP ('.')
BUFFER	DB	'Response needed: PRESS ANY KEY TO ADVANCE'
	DB	40 DUP ('.'),'$'
INIT:
	PUSH	SI			;save registers SI
	PUSH	DI			;and DI                        
	MOV	SI,80H			;point SI to the text          
	CLD				;go forward                    
	CALL	SPACE			;parse the spaces              
	CMP	BYTE PTR [SI],13	;is it a carriage control?     
	JE	XXX			;yes - then jump               
	MOV	CX,40			;no, place 40 into CX          
	LEA	DI,BUFFER		;point buffer to DI            
X:	LODSB				;get character from SI to AL   
	CMP	AL,13			;is it a carriage control char?
	JE	XX			;yes, then exit                
	STOSB				;no, store it in the buffer    
	LOOP	X			;do process again until CX is 0
XX:	INC	CX			;change carriage control to '.' 
	MOV	AL,'.'			;place a period in AL          
REP	STOSB				;repeat the store until CX is 0
XXX:	POP	DI			;restore registers DI          
	POP	SI			;and SI                        
	MOV	AH,1			;turn the cursor off           
	MOV	CX,0F00H		;with this address             
	INT	10H                                                    
WAIT:	MOV	AH,2			;place the cursor here         
	MOV	DH,24			;at row 24                     
	MOV	DL,19			;column 00                     
	INT	10H                                                    
AGAIN:	MOV	STORE,-1		;set value to -1               
INCR:	ADD	STORE,1			;increment the value           
	MOV	BL,STORE		;place it into BL              
	MOV	BH,0			;ready BX to be the index      
	MOV	CX,39			;going to do this 80 times     
	CALL	POS_CURSOR		;position cursor               
LOOP1:	MOV	AL,MSG[BX]		;put byte from msg area in AL  
	MOV	AH,14			;set up for teletype print    
	INT	10H                                                    
	INC	BX			;increment the index           
	CALL	PAUSE			;lets wait awhile              
	MOV	AH,1			;check for a key depression    
	INT	16H                                                    
	JZ	SKIP			;if not skip it                
	JMP	EXIT			;if so exit now                
SKIP:	LOOP	LOOP1			;loop back until CX is zero    
	CMP	MSG[BX],'$'		;is the msg area at the end?   
	JE	AGAIN			;yes, then go again            
	JMP	INCR			;go back and start all over    
SPACE:	INC	SI			;find first char in the text   
	CMP	BYTE PTR [SI],32	;is it a space?               
	JZ	SPACE			;if so do it again             
	RET				;return                        
POS_CURSOR:				;position the cursor           
	PUSH	BX			;save BX register              
	MOV	AH,2			;set up to move cursor         
	MOV	DH,24			;start in row 24               
	MOV	DL,19			;and column 00                 
	INT	10H                                                    
	POP	BX			;restore BX                    
	RET				;return                        
PAUSE:	PUSH	CX			;save CX                       
	MOV	CX,600			;loop 300 times for pause      
BACK:	LOOP	BACK			;loop til CX is zero           
	POP	CX			;restore CX                    
	RET				;return                        
EXIT:	CALL	POS_CURSOR		;prepare to erase the message 
	MOV	CX,79                                                  
EXIT2:	MOV	AL,' '			;place a blank into AL         
	MOV	AH,14			;prepare to teletype char      
	INT	10H                                                    
	LOOP	EXIT2			;loop til CX is zero           
	MOV	AH,1			;restore the cursor            
	MOV	CH,11			;part of cursor in CH          
	MOV	CL,12			;the rest goes here in CL      
	INT	10H                                                    
	INT	20H			;return to DOS
CSEG	ENDS
	END	START
