
PROGRAM Coprocessor_Clock;
  {$V-,C-}  {NOTE These two compiler switches are ESSENTIAL\}
TYPE
  AnyString = STRING[255];

VAR
  PresentColor,
  PresentBackGround : Byte;      {global variables for colour control}
  Hour, Min, Sec    : Byte;      {global variables for clock control}
  TheString         : AnyString;      
  Count             : Byte;      {global variables for main program}

  PROCEDURE SetColor(F, B : Byte);
  BEGIN
    PresentColor := F;        {remember the colour settings}
    PresentBackGround := B;
    TextColor(F);             {and implement them}
    TextBackground(B);
  END;

  PROCEDURE Clock;            { clock display }
  TYPE
    RegPack = RECORD
                CASE Integer OF
                  1 : (AX, BX, CX, DX, BP, SI, DI, DS, ES, Flags : Integer);
                  2 : (AL, AH, BL, BH, CL, CH, DL, DH : Byte);
              END;
  VAR
    ColumnHold, RowHold, ColorHold, BackGrndHold : Byte;
    Tmp : STRING[2];
    Time : STRING[8];
    Regs : RegPack;

  BEGIN
    WITH Regs DO
      BEGIN                   {get time from msdos}
        AH := $2C;          {call the clock interrupt}
        MsDos(Regs);
        {did the time change ? }
        IF (CH <> Hour) OR (CL <> Min) OR (DH <> Sec) THEN
        {delete the (DH <> Sec) if you don't want seconds display}
          BEGIN
            Hour := CH;       {save the new time}
            Min := CL;
            Sec := DH;        {delete if you dont want seconds display}
            RowHold := WhereY; {save the present cursor position}
            ColumnHold := WhereX;
            ColorHold := PresentColor; {save the present colour}
            BackGrndHold := PresentBackGround;
            Str(Hour:2, Tmp);
            Time := Tmp;
            Str(Min:2, Tmp);
            Time := Time+':'+Tmp;
            Str(Sec:2, Tmp);  {delete if you dont want seconds display}
            Time := Time+':'+Tmp; {delete if you dont want seconds display}
            GoToXY(70, 1);    {go and display the time}
            SetColor(LightCyan, Black);
            Write(Time);
            GoToXY(ColumnHold, RowHold); {restore the cursor position}
            SetColor(ColorHold, BackGrndHold); {and the colour}
          END;
      END;
  END;

  FUNCTION KeyInCoprocess : Char;
    { get characters from the keyboard }
  VAR
    KeyToGet : Char;
  BEGIN                            {if no key pressed then do something else}
    WHILE NOT KeyPressed DO Clock; {it does not have to be just the clock}
    Read(Kbd, KeyToGet);
    KeyInCoprocess := KeyToGet;
  END;

  PROCEDURE NewRead(VAR StringToGet : AnyString);
  {This procedure replaces the 'Read' procedure to read a string.  It would
   require modification if you want to input integers or reals directly.}
  VAR
    CharacterIn, Discard : Char;
  CONST
    Return = ^M;
    BackSpace = ^H;
    Space = ' ';
    Escape = ^[;
    Beep = ^G;

  BEGIN
    StringToGet := '';        {clear the string}
    REPEAT
      CharacterIn := KeyInCoprocess; {get a key if one is ready}
      CASE CharacterIn OF     {check what sort of key}
        ' '..'z' : BEGIN {'Normal' character. - you can select any 
                         acceptable range of characters here}
                     Write(CharacterIn); {write it}
                     StringToGet := StringToGet+CharacterIn; 
                     {append it to the string}
                   END;
        BackSpace : IF StringToGet[0] > #0 THEN
                      BEGIN
                        StringToGet[0] := Pred(StringToGet[0]); 
                        {remove the last character from the string}
                        Write(BackSpace); {backspace on the screen}
                        Write(Space);     {write a blank}
                        Write(BackSpace); {and backspace again}
                      END;
        Escape : BEGIN
                   IF KeyPressed THEN Discard := KeyInCoprocess;
                   {you could implement something with the cursor
                    or function keys here.}
                 END;
        Return : ;   {don't do anything}
      ELSE Write(Beep);       {tells you if you typed something odd}
      END;
    UNTIL (CharacterIn = Return) OR (StringToGet[0] = #255);
    {repeat until return is typed or the string overflows}
  END;

BEGIN                         {main program}
  SetColor(Red, White);
  ClrScr;
  GoToXY(70, 2);  Write('+---+--+');
  FOR Count := 3 TO 9 DO
    BEGIN
      GoToXY(74, Count);  Write('|');
    END;
  GoToXY(29, 10);  Write('Testing Clock Routine -----------------------+');
  GoToXY(20, 15);  Write('Take about a minute to enter this message');
  GoToXY(25, 16);  Write('and watch the clock being updated.');
  GoToXY(1, 12);   SetColor(Black, White);
  Write('+------------------------------ Input a String');
  Write(' -------------------------------+');
  GoToXY(1, 13);  SetColor(Yellow, White);
  NewRead(TheString);
  GoToXY(1, 20);  SetColor(Black, Magenta);
  Write('+------------------------------ The String Was');
  Write(' -------------------------------+');
  GoToXY(1, 21);     SetColor(Black, White);
  Write(TheString);  GotoXY(1,24);
END.

