{$R+}
PROGRAM convertr;
  {Demonstrates conversion of Turbo and Turbo-87 real numbers
  or vice versa using rfrom6 and rfrom8}

TYPE
  buff6 = ARRAY[0..5] OF Byte;
  buff8 = ARRAY[0..7] OF Byte;
  str80 = STRING[80];
VAR
  sourcelength, destlength,
  i, ActualRead        : Integer;
  sourcename, destname : str80;
  print                : Char;
  r                    : Real;
  fi, fo               : FILE;
  is87                 : Boolean;
  buffer6              : ARRAY[1..1000] OF buff6;
  buffer8              : ARRAY[1..1000] OF buff8;

  PROCEDURE rfrom6(bufferin : buff6; VAR bufferout : buff8);
  VAR
    i, ex : Integer;
  BEGIN
    FillChar(bufferout, 8, 0);

    {if number=0 then exit}
    IF bufferin[0] = 0 THEN Exit;

    {change to 8087 offset (-129+1023) and reposition for 8087}
    ex := (bufferin[0]+894) SHL 4;
    {move the sign bit and hi part of exponent}
    bufferout[7] := Lo((bufferin[5] AND 128) OR Hi(ex));

    {move the lo part of exponent and part of mantissa}
    bufferout[6] := Lo(Lo(ex) OR (bufferin[5] SHR 3 AND 15));

    FOR i := 5 DOWNTO 2 DO
      bufferout[i] := Lo((bufferin[i] SHL 5) OR (bufferin[i-1] SHR 3));

    bufferout[1] := Lo((bufferin[1] SHL 5) {or 8} );
  END;

  PROCEDURE rfrom8(bufferin : buff8; VAR bufferout : buff6);
  VAR
    i, ex : Integer;
  BEGIN
    FillChar(bufferout, 6, 0);

    ex := ((bufferin[7] AND 127) SHL 4) OR (bufferin[6] SHR 4);
    {if exponent is 0, number is 0}
    IF ex = 0 THEN Exit;

    {change to turbo offset (-1023+129), deal with out of range numbers}
    ex := ex-894;
    IF ex < 1 THEN Exit;
    IF ex >= 255 THEN
      BEGIN
        r := 1e37;
        Exit;
      END;
    bufferout[0] := Lo(ex);

    {move the sign bit and part of mantissa}
    bufferout[5] := Lo((bufferin[7] AND 128) OR (bufferin[6] AND 15 SHL 3)
    OR (bufferin[5] SHR 5));

    FOR i := 4 DOWNTO 1 DO
      bufferout[i] := Lo((bufferin[i+1] SHL 3) OR (bufferin[i] SHR 5));
  END;

  PROCEDURE CheckVersion;
  BEGIN
    CASE SizeOf(Real) OF
      6 : Is87 := False;
      8 : Is87 := True;
      10 : BEGIN
             WriteLn('You cannot use this procedure with TURBOBCD');
             Halt;
           END;
    END;
  END;

BEGIN
  ClrScr;
  CheckVersion;
  WriteLn('CONVERTR creates files with 8 byte real numbers from files with');
  WriteLn('6 byte real numbers, or vice versa.');
  WriteLn;
  IF Is87 THEN WriteLn('You are running TURBO-87,COM')
  ELSE WriteLn('You are running plain TURBO.COM');
  WriteLn;
  REPEAT
    Write('Does the source file have 6 or 8 byte real numbers? ');
    ReadLn(sourcelength);
  UNTIL sourceLength IN [6, 8];
  IF sourcelength = 6 THEN destlength := 8 ELSE destlength := 6;

  Write('Source file name? '); ReadLn(sourcename);
  Write('Destination file name? '); ReadLn(destname);

  Write('Display all real numbers on screen (y/n)? ');
  ReadLn(print);
  print := UpCase(print);

  Assign(fi, sourcename); Reset(fi, sourcelength);
  Assign(fo, destname); Rewrite(fo, destlength);

  REPEAT
    IF sourcelength = 6 THEN
      BEGIN
        BlockRead(fi, buffer6, 1000, ActualRead);
        FOR i := 1 TO ActualRead DO rfrom6(buffer6[i], buffer8[i]);
        BlockWrite(fo, buffer8, ActualRead);
      END
    ELSE
      BEGIN
        BlockRead(fi, buffer8, 1000, ActualRead);
        FOR i := 1 TO ActualRead DO rfrom8(buffer8[i], buffer6[i]);
        BlockWrite(fo, buffer6, ActualRead);
      END;
    IF print = 'Y' THEN
      FOR i := 1 TO ActualRead DO
        BEGIN
          IF Is87 THEN Move(buffer8[i], r, 8)
          ELSE Move(buffer6[i], r, 6);
          WriteLn(r);
        END;
  UNTIL ActualRead = 0;
  Close(fi);
  Close(fo);
END.

