{$R+,C-}
PROGRAM PageDemo;
TYPE
  String80 = STRING[80];
  Regpack = RECORD
    CASE Integer OF
      1:(AX,BX,CX,DX,BP,SI,DI,DS,ES,Flags : Integer);
      2:(AL,AH,BL,BH,CL,CH,DL,DH : Byte);
    END;
VAR
  Regs  : RegPack;
  Data  : String80;
  I, J  : Integer;
  dummy : Char;


  PROCEDURE Setpage(page : Byte);
    { Sets the current displayed page using INT 10h.  All "Writes" }
    { still goes to page 0 -- this procedure just changes which    }
    { page is visible.                                             }
  BEGIN
    Regs.AH := 5;
    Regs.AL := page;
    Intr($10, Regs);
  END;

  PROCEDURE ClrPage(Page, Background : Byte);
    { Clears the page using INT 10h services to write spaces }
    { over the whole page.                                   }
  BEGIN
    WITH Regs DO
      BEGIN
        {** Locate cursor first **}
        DL := 0;              { Column              }
        DH := 0;              { Row                 }
        BH := Page;           { Page                }
        AH := 2;              { Set Cursor Position }
        Intr($10, Regs);
        {** Now write characters **}
        AH := 9;              { Write Char w/ attr. }
        BH := Page;           { Page                }
        BL := Background*16;  { attribute byte      }
        AL := Ord(' ');       { Char to write       }
        CX := 2000;           { # of times to write }
        Intr($10, Regs);
      END;
  END;


  PROCEDURE PutPage(VAR Data : String80; Page, Col, Row, Back, Fore : Byte);
    { Uses INT 10h to write a string to the selected page. }
    { Arguments are:                                       }
    {    1) A String[80] to write    }
    {    2) the Page to Write to     }
    {    3) the Column To Start at   }
    {    4) the Row To Write in      }
    {    5) the BackGround Color     }
    {    6) the Foreground Color     }
  VAR
    Endcol : Byte;
    L, I   : Integer;
  BEGIN
    Col := Col-1; {Turbo uses 1..80, BIOS uses 0..79}
    Row := Row-1; {Turbo uses 1..25, BIOS uses 0..24}
    IF (Col < 0) OR (Col > 79) THEN Col := 0;
    IF (Row < 0) OR (Row > 24) THEN Row := 0;
    IF (Page < 0) OR (Page > 3) THEN Page := 0;
    L := Length(Data);
    EndCol := Col+L;
    IF EndCol > 79 THEN
      BEGIN
        EndCol := 79;
        L := EndCol-Col;
      END;
    FOR I := 0 TO (L-1) DO
      BEGIN
        WITH Regs DO
          BEGIN
            {  **  Locate Cursor First  ** }
            DL := Col+I;      { Column              }
            DH := Row;        { Row                 }
            BH := Page;       { Page                }
            AH := 2;          { Set Cursor Position }
            Intr($10, Regs);
            { Now Write Character }
            AH := 9;          { Write Char w/ attr. }
            BH := Page;       { Page                }
            BL := Back*16+Fore; { attribute byte    }
            AL := Ord(Data[I+1]); {char to write    }
            CX := 1;          { # of times to write }
            Intr($10, Regs);
          END;
      END;
  END;

BEGIN
  WriteLn('WARNING: ONLY works on color/graphics system.');
  FOR J := 1 TO 3 DO
    BEGIN
      Data := 'Data Data Data Data Data Data Data Data '+
              'Data Data Data Data Data Data Data Data ';
      WriteLn('Building Page ', J);
      ClrPage(J, J);
      FOR I := 1 TO 24 DO
        Putpage(Data, J, 1, I, J, White);
      Data := 'Press any key to continue...';
      PutPage(Data, J, 1, 25, White, J);
    END;
  WriteLn('Press key for first page'); Read(Kbd, dummy);
  setpage(1); Read(Kbd, dummy);
  setpage(2); Read(Kbd, dummy);
  setpage(3); Read(Kbd, dummy);
  setpage(0); WriteLn('We''re back'); {Read(Kbd, dummy);}
END.