/* pcprint.c
 *  For MSC 5.0/QuickC: cl pcprint.c
 *  For Turbo C:        tcc -DTURBOC pcprint.c
 */

#include<stdio.h>
#include<bios.h>

                /* printer error code bits */
#define PR_TIMEOUT    0x0001
#define UNUSED_1    0x0002
#define UNUSED_2    0x0004
#define PR_IOERR    0x0008
#define PR_SELECT     0x0010
#define PR_PAPEROUT   0x0020
#define PR_ACKNOWLEDGE  0x0040
#define PR_NOTBUSY    0x0080

#define PRINT_ERRS 3

struct _printerrs
{
  char *errmsg;
  int errval;
} printerrs[PRINT_ERRS] =
{
  "Printer time out", PR_TIMEOUT,
  "I/O Error",PR_IOERR,
  "Out of Paper",PR_PAPEROUT,
};

              /* general purpose macros */
#define PRINTER_ERRBITS (PR_TIMEOUT | PR_IOERR | PR_PAPEROUT)
#define LPT1 0
#define LPT2 1
#define PRINTER_TIMEOUT_ADDR  0x00400078
#define PRINTER_WRITE 0

/*
 * this function sets the printer timeout to 'val' for printer 'pr'
 */
void SetPrTimer(val, pr)
int val, pr;
{
  unsigned char far *Pr_tim_out = (unsigned char far *)PRINTER_TIMEOUT_ADDR;

  Pr_tim_out[pr] = val;        /* set printer time out value */
}

/*
 * this function gets the printer timeout value for printer 'pr'
 */
int GetPrTimer(pr)
int pr;
{
  unsigned char far *Pr_tim_out = (unsigned char far *)PRINTER_TIMEOUT_ADDR;

  return Pr_tim_out[pr];         /* get printer time out value */
}

/* this function prints an error message for the printer error bits set
 * in errval
 */
void PcPrinterr(errval)
unsigned errval;
{
  int i;

  printf("\nPrinter error: ");

  for( i = 0; i < PRINT_ERRS; i++)
    if(errval & printerrs[i].errval)
      printf(" %s",printerrs[i].errmsg);
}

unsigned PcPrint(str, pr)
char *str;
int pr;
{
  unsigned retval;
  
  for( ; *str; str++)
#ifdef TURBOC
    if( (retval = biosprint(PRINTER_WRITE, (unsigned)*str, pr))
       & PRINTER_ERRBITS)
#else
    if( (retval = _bios_printer(PRINTER_WRITE, pr, (unsigned)*str))
       & PRINTER_ERRBITS)
#endif
      return (retval & PRINTER_ERRBITS);
  return 0;
}

main()
{
  unsigned retval;
  int oldval;

  oldval = GetPrTimer(LPT1);            /* get old timer value */
  SetPrTimer(1,LPT1);                 /* set new timer value */

  if(retval = PcPrint("this is a test\n", LPT1))  /* print the string */
    PcPrinterr(retval);               /* report any error */
  else
    printf("\nPrint test was successful");

  SetPrTimer(oldval, LPT1);             /* set the timer value */
  exit(0);
}
