***********************************************************************
* ACTMENU.PRG - Demonstrate FoxPro ACTIVATE MENU
***********************************************************************
CLEAR
SET BORDER TO SINGLE                  && Single line border
*
* Confine to our window
*
DEFINE WINDOW win1 FROM 2,5 TO 23,74 TITLE "ACTMENU.PRG"
ACTIVATE WINDOW win1
*
* First define the actionbar
*
DEFINE MENU foxmenu
DEFINE PAD systemp  OF foxmenu PROMPT '\<System'   AT 00,00
DEFINE PAD filep    OF foxmenu PROMPT '\<File'     AT 00,08
DEFINE PAD editp    OF foxmenu PROMPT '\<Edit'     AT 00,14

ON PAD systemp OF foxmenu  ACTIVATE POPUP syspop
ON PAD filep   OF foxmenu  ACTIVATE POPUP filepop

ON SELECTION PAD editp OF foxmenu DO msgwin WITH "You chose PAD ";
   +PAD()+" of the "+MENU()+" menu",;
   "Menu pad "+'"'+ALLTRIM(PROMPT())+'"'+" is not implemented"
*
* Now define the drop-down menus
*
DEFINE POPUP syspop FROM 01,00 SHADOW
DEFINE BAR  1 OF syspop    PROMPT ' \<About FoxPro...'
DEFINE BAR  2 OF syspop    PROMPT ' \<Help...         F1'
DEFINE BAR  3 OF syspop    PROMPT ' \<Macros...'
DEFINE BAR  4 OF syspop    PROMPT '\-'    SKIP
DEFINE BAR  5 OF syspop    PROMPT ' \<Filer'
DEFINE BAR  6 OF syspop    PROMPT ' \<Calculator'
DEFINE BAR  7 OF syspop    PROMPT ' Calendar/\<Diary'
DEFINE BAR  8 OF syspop    PROMPT ' \<Special Characters '
DEFINE BAR  9 OF syspop    PROMPT ' ASC\<II Chart'
DEFINE BAR 10 OF syspop    PROMPT ' Ca\<pture'
DEFINE BAR 11 OF syspop    PROMPT ' Pu\<zzle'

DEFINE POPUP filepop FROM 01,08 SHADOW
DEFINE BAR  1 OF filepop   PROMPT ' \<New...'
DEFINE BAR  2 OF filepop   PROMPT ' \<Open...'
DEFINE BAR  3 OF filepop   PROMPT ' \<Close'
DEFINE BAR  4 OF filepop   PROMPT '\-'  SKIP
DEFINE BAR  5 OF filepop   PROMPT '\ \<Save'            && Unselectable
DEFINE BAR  6 OF filepop   PROMPT '\ Sa\<ve As...'
DEFINE BAR  7 OF filepop   PROMPT '\ \<Revert'
DEFINE BAR  8 OF filepop   PROMPT '\-' SKIP
DEFINE BAR  9 OF filepop   PROMPT ' Pr\<inter Setup... '
DEFINE BAR 10 OF filepop   PROMPT ' \<Print...'
DEFINE BAR 11 OF filepop   PROMPT '\-' SKIP
DEFINE BAR 12 OF filepop   PROMPT ' \<Quit'

ON SELECTION POPUP syspop  DO sysproc
ON SELECTION POPUP filepop DO fileproc

DO WHILE .T.
   ACTIVATE MENU foxmenu              && Stays active until DEACTIVATE MENU command
   && or ESC pressed (which deactivates it)
   IF (MENU()=="")                    && IF menu has been deactivated
      EXIT                            && Leave the loop
   ENDIF
ENDDO .T.
RELEASE MENU foxmenu                  && Remove menu from memory
RELEASE POPUPS ALL                    && Remove popups from memory
RELEASE WINDOW win1
RETURN

***********************************************************************
* PROCEDURE Sysproc handles options chosen from the System menu
***********************************************************************
PROCEDURE sysproc                     && Handle System menu options
* HIDE POPUP Syspop
DO msgwin WITH "You chose BAR ";
   +ALLTRIM(STR(BAR()))+" of the "+POPUP()+" popup",;
   "Option "+'"'+ALLTRIM(PROMPT())+'"'+" is not implemented"
DO CASE
CASE BAR() = 1                                  && About FoxPro...
   * Do something
CASE BAR() = 2                                  && Help...
   * Do something
CASE BAR() = 3                                  && Macros...
   * Do something
CASE BAR() = 4                                  && -----------
   * Do something
CASE BAR() = 5                                  && Filer
   * Do something
CASE BAR() = 6                                  && Calculator
   * Do something
CASE BAR() = 7                                  && Calendar/Diary
   * Do something
CASE BAR() = 8                                  && Special Characters
   * Do something
CASE BAR() = 9                                  && ASCII Chart
   * Do something
CASE BAR() = 10                                 && Capture
   * Do something
CASE BAR() = 11                                 && Puzzle
   * Do something
ENDCASE
RETURN

***********************************************************************
* PROCEDURE Fileproc handles options chosen from the File menu
***********************************************************************
PROCEDURE fileproc                    && Handle File menu options
* HIDE POPUP Filepop
DO msgwin WITH "You chose BAR ";
   +ALLTRIM(STR(BAR()))+" of the "+POPUP()+" popup",;
   "Option "+'"'+ALLTRIM(PROMPT())+'"'+" is not implemented"
DO CASE
CASE BAR() = 1                                  && New...
   * Do something
CASE BAR() = 2                                  && Open...
   * Do something
CASE BAR() = 3                                  && Close
   * Do something
CASE BAR() = 4                                  && ---------
   * Do something
CASE BAR() = 5                                  && Save'
   * Do something
CASE BAR() = 6                                  && Save As...
   * Do something
CASE BAR() = 7                                  && Revert'
   * Do something
CASE BAR() = 8                                  && ---------
   * Do something
CASE BAR() = 9                                  && Printer Setup...
   * Do something
CASE BAR() = 10                                 && Print...
   * Do something
CASE BAR() = 11                                 && --------
   * Do something
CASE BAR() = 12                                 && Quit'
   DEACTIVATE MENU                              && Finished...
ENDCASE
RETURN

***********************************************************************
* PROCEDURE msgwin Displays some messages in a window and waits for
*           a keypress
***********************************************************************
PROCEDURE msgwin                       && Display window to user
PARAMETER TEXT, text1
DEFINE WINDOW msgwin FROM 15,20 TO 21,71 TITLE '&text1' SHADOW
ACTIVATE WINDOW msgwin
@ 1, (50 - LEN(TEXT))/2 SAY TEXT
@ 2, (50 - LEN(text1))/2 SAY text1
@ 4, 7 SAY 'Press any key or click on the mouse'
=INKEY(0,'HM')                         && wait for keypress or mouse click
RELEASE WINDOW msgwin
RETURN

* EOF
