/*
KEYSPEED.C:     Set the typeamatic rate and delay on the keyboard

version:        11-02-89
compiler:       QuickC 2.01
uses:           stdtype.h, stdio.h, stdlib.h, bios.h
module type:    .EXE (small model)

(C) Copyright 1989 Marty Franz
*/

#include <stdio.h>
#include <stdlib.h>
#include <bios.h>

#define KEYBOARD 0x16        /* keyboard interrupt */
#define SET_RATES 0x0305     /* services to set rate and delay */

char *rates[32] = 
{
	"30.0", "26.7", "24.0", "21.8", "20.0", "18.5", "17.1",
	"16.0", "15.0", "13.3", "12.0", "10.9", "10.0",  "9.2",
	"8.6",  "8.0",  "7.5",  "6.7",  "6.0",  "5.5",  "5.0",
	"4.6",  "4.3",  "4.0",  "3.7",  "3.3",  "3.0",  "2.7",
	"2.5",  "2.3",  "2.1",  "2.0"
}
;

char *delays[4] = 
{
	"250", "500", "750", "1000"
}
;

void main(int argc, char *argv[], char *envp[])
{
	int temp;
	union REGS inregs, outregs;

	if (argc != 3)
	{
		printf("Usage: %s <rate> <delay>\n", argv[0]);
		puts("Sets keyboard typematic rate and delay.");
		puts("Use 0 0 for fastest, 31 3 for slowest.");
		exit(1);
	}
	inregs.x.ax = SET_RATES;
	temp = atoi(argv[1]);
	inregs.h.bl = (temp < 0x20) ? temp : 0x1f;
	temp = atoi(argv[2]);
	inregs.h.bh = (temp < 0x04) ? temp : 0x03;
	printf("Rate: %s characters/second\nDelay: %s milliseconds\n",
	  rates[inregs.h.bl], delays[inregs.h.bh]);
	int86(KEYBOARD, &inregs, &outregs);
	exit(0);
}
