(*
**    File:    makeform.pas
**    Purpose: Create CUSTFORM.DTA file with type from UNEWTYPE
**    Author:  (c) 1989 by Tom Swan. All rights reserved.
*)

program MakeForm;

uses Crt, Forms, Sliders, uNewType, uFormGen;

type  FnameString = string[65];     { File name string type }

const FORMFILE = 'MUSIC.DTA';       { Name for new file }

   
{---- Design a new data-entry form. }

{$F+}    { Turn on far-code generation. }
procedure newForm;
begin
   theForm.init( 9, 4, 71, 22 );
   theForm.add( new( FStrPtr,   
      init(  3,  3, ' Title      :', 45 ) ) );
   theForm.add( new( FStrPtr,   
      init(  3,  4, ' Composer   :', 22 ) ) );
   theForm.add( new( FStrPtr,   
      init(  3,  5, ' Instrument :', 22 ) ) );
   theForm.add( new( FStrPtr,   
      init( 38,  4, ' Label:', 16 ) ) );
   theForm.add( new( FStrPtr,   
      init( 38,  5, ' Type :', 6 ) ) );
   theForm.add( new( FStrPtr,   
      init( 52,  5, ' Tech:', 3 ) ) );
   theForm.add( new( FIntPtr,   
      init(  3,  6, ' Play Time  :', 0, 99 ) ) );
   theForm.add( new( FIntPtr,   
      init( 18,  6, ':', 0, 99 ) ) );
   theForm.add( new( FIntPtr,   
      init( 26,  6, ' (C):', 0, 2050 ) ) );
   theForm.add( new( FRealPtr,  
      init( 38,  6, ' Cost :', 6, 2 ) ) );
   theForm.add( new( FYesNoPtr, 
      init( 52,  6, ' Gift:' ) ) );
   theForm.add( new( FStrPtr,   
      init(  3,  8, ' Performer / director :', 22 ) ) );
   theForm.add( new( FStrPtr,   
      init(  3,  9, ' Producer             :', 22 ) ) );
   theForm.add( new( FStrPtr,   
      init(  3, 10, ' Sound Engineer       :', 22 ) ) );
   theForm.add( new( FYesNoPtr, 
      init( 49,  8, ' Taped  :' ) ) );
   theForm.add( new( FIntPtr,   
      init( 49,  9, ' Number :', 0, 999 ) ) );
   theForm.add( new( FStrPtr,   
      init(  3, 12, ' Notes:', 51 ) ) );
   theForm.add( new( FSliderPtr,
      init(  3, 14, ' Performance quality :', 0, 100, 5 ) ) );
   theForm.add( new( FSliderPtr,
      init(  3, 15, ' Recording quality   :', 0, 100, 5 ) ) );
   theForm.add( new( FYesNoPtr, 
      init(  3, 17, ' On loan :' ) ) );
   theForm.add( new( FStrPtr,   
      init( 18, 17, ' To :', 22 ) ) );
   theForm.add( new( FIntPtr,   
      init( 46, 17, ' Date :', 0, 12 ) ) );
   theForm.add( new( FIntPtr,   
      init( 55, 17, '/', 0, 31 ) ) );
   theForm.add( new( FIntPtr,   
      init( 58, 17, '/', 0, 99 ) ) );
end; { newForm }
{$F-}    { Turn off "far" code generation. }


{---- Return True if file exists in current directory }

function fileExists( fname : FnameString ) : Boolean;
var
   f : File;
begin
   assign( f, fname );
   {$i-} reset( f ); {$i+}    { Try to open the file }
   if ioresult = 0 then
   begin
      fileExists := True;     { Return true if file open }
      close( f )              { Then, close the file }
   end else
      FileExists := False     { Return false if not open }
end; { FileExists }


{---- Main program }

begin
   if FileExists( FORMFILE )
   then
      writeln( FORMFILE, ' already exists' )
   else begin
      writeln( 'Creating new ', FORMFILE );
      MakeFile( NewForm, FORMFILE );
   end { else }
end. { MakeForm }
