' NBSTIME.BAS  M. Covington  1989
' Turbo BASIC 1.0 and up, QuickBASIC 2.0 and up

' ************************
' * Function Definitions *
' ************************

' FNstr$(num)
' Like STR$ (built in) but result has no leading blank.

DEF FNstr$ (num)
  X$ = STR$(num)
  FNstr$ = RIGHT$(X$, LEN(X$) - 1)
END DEF

' FNdaysin(month,year)
' gives number of days in nth month of specified year.

DEF FNdaysin (month, year)
  days = 31
  IF month=4 OR month=6 OR month=9 OR month=11 THEN days = 30
  IF month=2 THEN days = 28
  IF month=2 AND (year MOD 4)=0 THEN days = 29
  FNdaysin = days
END DEF

' ******************
' *  Main Program  *
' ******************

' Open serial port and tell Hayes modem to dial

  CLS
  PRINT "Calling NBS to obtain time of day and set clock..."
  ON ERROR GOTO ErrorHandler
  OPEN "COM1:1200,E,7,1,CS,DS,CD" AS #1
  PRINT #1, "ATDT 1-303-494-4774"

GetLine:

' Read a line from serial port into text$,
' ending with CHR$(10) (line feed).
' Store "TIMEOUT" if nothing is received after 100,000 tries
' (up to 2 minutes depending on machine).

  text$ = "": tries = 0

  WHILE (tries<100000) AND (RIGHT$(text$, 1)<>CHR$(10))
    IF NOT EOF(1) THEN
      text$ = text$ + INPUT$(1,#1)
      tries = 0
    END IF
    tries = tries + 1
  WEND
  IF tries=100000 THEN text$ = "TIMEOUT"

' Discard the Return and Line Feed at end of line.

  WHILE LEN(text$)>0 AND RIGHT$(text$, 1)<" "
       text$ = LEFT$(text$, LEN(text$) - 1)
  WEND

' Check data received.
' If modem error message, bail out.
' If not 49-char line, read another line.

  IF text$="TIMEOUT" OR text$="NO CARRIER" OR text$="BUSY" THEN
    PRINT text$; " -- Unable to connect."
    GOTO Finish
  ELSEIF LEN(text$) <> 49 THEN
    GOTO GetLine
  END IF

  PRINT "Data received from NBS:"
  PRINT text$

' Convert date to numbers to do time zone conversion.
' Minutes, seconds, unaffected, remain a string.

  yr = VAL(MID$(text$,7,2))
  mo = VAL(MID$(text$,10,2))
  da = VAL(MID$(text$,13,2))
  hr = VAL(MID$(text$,16,2))
  minsec$ = MID$(text$,18,6)

' Convert to user's time zone and check daylight saving time.

  hr = hr - 5      ' Eastern time is -5, Pacific is - 8.

  dst = VAL(MID$(text$, 25, 2))
  IF dst>1 AND dst<51 THEN hr = hr + 1

' If hour<0, change date to previous day.

  IF hr<0 THEN hr = hr + 24: da = da - 1
  IF da=0 THEN mo = mo - 1: da = FNdaysin(mo, yr)
  IF mo=0 THEN yr = yr - 1: mo = 12

' Assume user is in western hemisphere and local time is
' always *behind* UTC, so no need to check for hr > 23.

' Set the system clock

  DATE$ = FNstr$(mo) + "-" + FNstr$(da) + "-" + FNstr$(yr)
  TIME$ = FNstr$(hr) + minsec$
  PRINT "Date and time have been set to: "; DATE$; " "; TIME$

' Close serial port, which drops DTR and hangs up phone

Finish:
  CLOSE #1
  END

' *******************
' *  Error Handler  *
' *******************

' Ignore parity, framing, overrun errors (Error 57)

ErrorHandler:
  IF ERR<>57 THEN PRINT "<Runtime error ";ERL;">"
  RESUME
