(*
**    File:    readcard.pas
**    Purpose: Read and display data in a card file.
**    Author:  (c) 1989 by Tom Swan. All rights reserved.
*)

program ReadCard;

uses Crt, Objects, Forms, Sliders, UNewType, Cards, UFormGen;

{ ---- Halt program with an error message }
procedure error( message : string );
begin
   writeln;
   writeln( 'ERROR: ', message );
   halt( 1 )
end; { error }

{ ---- Load cards and field definitions into memory }
procedure ReadCards;
var   
   header: LongInt;     { Card file signature header }
begin
{- Open the stream }
   theStream.init( paramStr(1), SOPEN, 1024 );
{- Test status of previous init }
   if theStream.Status <> 0 
      then error( 'Can''t open ' + paramStr(1) );
{- Read and verify header }
   theStream.read( header, SizeOf( LongInt) );
   if header <> SIGNATURE 
      then error( 'Not a card file' );
{- Load the field definitions and cards }
   theForm.load( theStream );
   theCards.load( theStream );
   if theStream.Status <> 0 
      then error('Disk read error');
end; { ReadCards }

{ ---- Display field titles and data in each card }
procedure DisplayCards;
var
   i, j : integer;   { For-loop and temp vars }
   s : FString;      { String for displaying data }
   p : NodePtr;      { Recast to field object type }
begin
{- Loop for however many cards are in memory }
   for i := 1 to theCards.Count do
   begin
   {- Transfer one card to field list }
      theForm.Put( theCards.CardData^ );
   {- Assign address of first field to p }
      p := theForm.Fields.First;
      while p <> nil do
      begin
      {- Can't display slider fields as text! }
         if TypeOf( p^ ) <> TypeOf( FSlider ) then
         begin
         {- Assign and display field title }
            s := FTextPtr( p )^.Title^;
            j := pos( ':', s );
            if j <> 0 then delete( s, j, 1 );
            if length( s ) > 12 then s := copy( s, 1, 12 );
            write( s, ' ':13 - length(s), ': ' );
         {- Load field data into string s and display it }
            FTextPtr( p )^.GetStr( s );
            writeln( s );
         end; { if }
         {- Get next field. If last, p will = nil }
         p := theForm.Fields.Next( p );
      end; { while }
      {- Move 'Current' pointer to next card }
      theCards.Next;
      writeln;
      write( 'Press ENTER to continue...' );
      readln;
   end; { for }
end; { DisplayCards }

begin
   ReadCards;        {- Load fields and cards into memory }
   DisplayCards;     {- Display card-file records }
   theStream.Done;   {- Close the stream and clean up }
end.
