/* Listing 1. C program to expand tabs in a file */

#include <stdio.h>

FILE *f;           /* input file stream              */
int col = 0;       /* current column of current line */
int tabsize = 8;   /* given tab size                 */
int tabcnt = 0;    /* amount of spaces left          */

int tabexp_get(void)
/* Gets a character from the input file, */
/* expanding tabs along the way          */
{
  int c;

  if (tabcnt) {  /* currently expanding tab */
     tabcnt--; col++;
     c = ' ';
  }
  else c = fgetc(f);

  if (c == 0x09) { /* tab handler */
     tabcnt = tabsize - (col % tabsize);
     return tabexp_get();
  }
  else {
    if (c == '\n') col = 0; else col++;
  }
  return c;
}

main()
{
  int c;

  f = stdin; /* default to stdin for input file */
  do {       /* loop until no more characters in input */
    c = tabexp_get();
    if (c == -1) break; else putc(c, stdout);
  } while(1);
}
