(*
**    File:    uformgen.pas
**    Purpose: Routines for generating new CARDFILE forms.
**    Author:  (c) 1989 by Tom Swan. All rights reserved.
*)

unit UFormGen;

interface

uses  Crt, Objects, Cards, Forms, Sliders, UNewType;

const SIGNATURE : Longint = $44524143;    { Do not change! }

type  NewFormProc = procedure;

var
  theForm: Form;
  theCards: CardList;
  theStream: FStream;

procedure makeFile( formp : NewFormProc; filename : FNameStr );


implementation

{---- Create a new card file }

procedure makeFile( formp : NewFormProc; filename : FNameStr );
begin
   formp;   { Create the new form in memory }
   theCards.init( theForm.size );
   theStream.init( filename, SCREATE, 1024 );
   theStream.write( SIGNATURE, sizeof(Longint) );
   theForm.store( theStream );
   theCards.store( theStream );
   theStream.flush;
   if theStream.status <> 0 
      then writeln( 'Error creating file ', filename );
   theStream.done;
   theCards.done;
   theForm.done;
end; { makeFile }

end. { UFormGen }
