(*
**    File:    unewtype.pas
**    Purpose: Add new data type to FORMS unit
**    Author:  (c) 1989 by Tom Swan. All rights reserved.
*)

unit UNewType;

interface

uses Forms, Sliders;

type

   FYesNoPtr = ^FYesNo;
   FYesNo = object( FText )
      constructor init( px, py : Integer; ptitle : FString );
      procedure getStr( var s : FString ); virtual;
      function putStr( var s : FString ) : Boolean; virtual;
   end; { FYesNo }

   FStream = object( Sliders.FStream )
      procedure registerTypes; virtual;
   end; { FStream }


implementation


{---- Construct and initialize a new FYesNo object }

constructor FYesNo.init( px, py : Integer; ptitle : FString );
begin
   FText.init( px, py, sizeof( Boolean ), ptitle, 3 );
end; { init }


{---- Return a string (s) that represents the current
value of the FYesNo object. }

procedure FYesNo.getStr( var s : FString );
begin
   if Boolean( value^ )
      then s := 'Yes'
      else s := 'No '
end; { GetStr }


{---- Change current FYesNo object value according to
whether the input string (s) begins with 'Y' or 'N'. }

function FYesNo.putStr( var s : FString ) : Boolean;
begin
   if length( s ) > 0
      then Boolean( value^ ) := upcase( s[1] ) = 'Y'
      else Boolean( value^ ) := FALSE;
   PutStr := TRUE
end; { putStr }


{---- Register all data types plus the new FYesNo
object with the Objects unit Stream manager. }

procedure FStream.registerTypes;
begin
   Sliders.FStream.registerTypes;
   Register( typeof( FYesNo ), @FYesNo.store, @FYesNo.load );
end; { registerTypes }

end. { UNewType }
