;** BSOUND.ASM - simulates BASIC's SOUND statement for any language
;
;Copyright (c) 1990 Ethan Winer
;
;Syntax: CALL BSound(Frequency%, Duration%)
;
;Where Frequency% is the frequency in Hertz (cycles per second) and
;Duration% is the number of 1/18ths second to sustain the tone.
;These parameters are identical to those for the SOUND statement in
;the BASIC reference manual, and the range of values for the pitch
;is the same: 37 Hz to 32767 Hz.
;
;This file is intended to be assembled with MASM 5.1 or later.


.Model Medium, Basic
.Code

BSound Proc, Frequency:Word, Duration:Word

    Mov  AL,10110110b     ;initialize Timer 2
    Out  43h,AL

    Mov  DX,12h           ;load DX:AX with 1,190,000 to convert
    Mov  AX,2870h         ;  the incoming frequency to period (1/f)
    Mov  BX,Frequency     ;get the address for Frequency%
    Mov  BX,[BX]          ;put Frequency% into BX
    Cmp  BX,37            ;is it less than 37 Hz.?
    Jb   Exit             ;yes, avoid "Divide by zero" overflow err.
    Div  BX               ;now AX holds the correct timer
                          ; interval period

    Out  42h,AL           ;send the interval information to Timer 2
    Mov  AL,AH            ;get second byte
                          ; (a word must be sent as two bytes)
    Out  42h,AL           ;send it

    In   AL,61h           ;read timer port "B"
    Or   AL,00000011b     ;set the bits to turn the speaker on
    Out  61h,AL           ;turn it on

    Push Duration         ;show Pause where Duration% is
    Call Far Ptr Pause    ;delay for Duration% clock ticks

    In   AL,61h           ;read timer port "B"
    And  AL,11111100b     ;set the bits to turn the speaker off
    Out  61h,AL           ;turn it off

Exit:
    Ret                   ;return to caller

BSound Endp



Pause Proc, Ticks:Word

    Mov  BX,Ticks         ;get address for Ticks%
    Mov  CX,[BX]          ;put it in CX
    Jcxz Exit             ;zero is a mistake, avoid a LONG delay

    Xor  AX,AX            ;look at the low system timer byte
    Mov  ES,AX            ;through ES

Outer:
    Mov  AL,ES:[46Ch]     ;get the current timer count

Inner:
    Cmp  AL,ES:[46Ch]     ;has it changed?
    Je   Inner            ;no, keep checking
    Loop Outer            ;yes, loop until we've exhausted Ticks%

Exit:
    Ret                   ;return to caller

Pause Endp
End
