/* mouse.c -- Routines to support a Microsoft compatible mouse.
 * This package assumes that you are running under graphics mode.
 */
#include <dos.h>
#include <graphics.h>
#include <stdio.h>
#include "mouse.h"

/* Communicates with the mouse driver */
void mouse(int *m1, int *m2, int *m3, int *m4)
{
  union REGS inregs, outregs;

  inregs.x.ax = *m1;   inregs.x.bx = *m2;
  inregs.x.cx = *m3;   inregs.x.dx = *m4;
  int86(0x33,&inregs,&outregs);
  *m1 = outregs.x.ax;  *m2 = outregs.x.bx;
  *m3 = outregs.x.cx;  *m4 = outregs.x.dx;
}

/* Initialize the mouse */
int initmouse(void)
{
  int gmode, m1, m2, m3, m4;
  char far *memory = (char far *)0x004000049L;

  m1 = RESET_MOUSE;    mouse(&m1,&m2,&m3,&m4);
  if (m1) {
    /* Hercules card requires an extra step */
    gmode = getgraphmode();
    if (gmode == HERCMONOHI) {
      *memory = 0x06;
      m1 = RESET_MOUSE;  mouse(&m1,&m2,&m3,&m4);
    }
    mousestatus(SHOW_MOUSE);
    return(1);
  }
  else /* Mouse not found, return failure flag */
    return(0);
}

/* Hide or show the mouse */
void mousestatus(int stateofmouse)
{
  int m2, m3, m4;

  mouse(&stateofmouse,&m2,&m3,&m4);
}

/*  Get the current location of the mouse cursor */
void getmousecoords(int *x, int *y)
{
  int m1, m2;

  m1 = GET_MOUSE_STATUS;   mouse(&m1,&m2,x,y);
  /* Adjust for virtual coordinates of the mouse */
  if (getmaxx() == 319) (*x) /= 2;
}

/* Returns 1 if the mouse button condition specified occurred */
int buttonstatus(int condition, int whichbutton)
{
  int m3, m4;

  mouse(&condition,&whichbutton,&m3,&m4);
  if (whichbutton) return(1); else  return(0);
}
